/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.grpcexample;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.stargate.grpc.StargateBearerToken;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.StargateGrpc;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class GrpcClientExecuteQuery {
    private final StargateGrpc.StargateBlockingStub blockingStub;
    private final StargateGrpc.StargateStub asyncStub;
    private static final String STARGATE_TOKEN = "";
    private static final String STARGATE_HOST = "localhost";
    private static final int STARGATE_GRPC_PORT = 8090;

    public static void main(String[] args) throws InterruptedException {
        GrpcClientExecuteQuery grpcClientExecuteQuery = new GrpcClientExecuteQuery();
        grpcClientExecuteQuery.prepareSchema();
        grpcClientExecuteQuery.executeSingleQuery();
        grpcClientExecuteQuery.executeBatchQueries();
        grpcClientExecuteQuery.executeAsyncQueries();
        grpcClientExecuteQuery.executeStreamingQuery();
        grpcClientExecuteQuery.executeStreamingBatchQueries();
    }

    private void executeStreamingBatchQueries() throws InterruptedException {
        this.executeStreamingBatchInsertQueries();
        this.executeStreamingSelectQuery();
    }

    private void executeStreamingQuery() throws InterruptedException {
        this.executeStreamingInsertQuery();
        this.executeStreamingSelectQuery();
    }

    private void executeStreamingSelectQuery() throws InterruptedException {
        final CountDownLatch responseRetrieved = new CountDownLatch(1);
        StreamObserver<QueryOuterClass.StreamingResponse> responseStreamObserver = new StreamObserver<QueryOuterClass.StreamingResponse>(){

            public void onNext(QueryOuterClass.StreamingResponse value) {
                System.out.println("Select streaming response: " + value);
                responseRetrieved.countDown();
            }

            public void onError(Throwable t) {
                System.out.println("Error: " + t);
            }

            public void onCompleted() {
                System.out.println("Select StreamObserver completed");
            }
        };
        StreamObserver queryStreamObserver = this.asyncStub.executeQueryStream((StreamObserver)responseStreamObserver);
        queryStreamObserver.onNext((Object)QueryOuterClass.Query.newBuilder().setCql("SELECT k, v FROM ks.test").build());
        queryStreamObserver.onCompleted();
        responseRetrieved.await();
    }

    private void executeStreamingBatchInsertQueries() throws InterruptedException {
        final CountDownLatch responseRetrieved = new CountDownLatch(2);
        StreamObserver<QueryOuterClass.StreamingResponse> responseStreamObserver = new StreamObserver<QueryOuterClass.StreamingResponse>(){

            public void onNext(QueryOuterClass.StreamingResponse value) {
                System.out.println("Batch streaming response: " + value);
                responseRetrieved.countDown();
            }

            public void onError(Throwable t) {
                System.out.println("Error: " + t);
            }

            public void onCompleted() {
                System.out.println("Batch StreamObserver completed");
            }
        };
        StreamObserver queryStreamObserver = this.asyncStub.executeBatchStream((StreamObserver)responseStreamObserver);
        queryStreamObserver.onNext((Object)QueryOuterClass.Batch.newBuilder().addQueries(QueryOuterClass.BatchQuery.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('streaming_batch_a', 1)").build()).addQueries(QueryOuterClass.BatchQuery.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('streaming_batch_b', 2)").build()).build());
        queryStreamObserver.onNext((Object)QueryOuterClass.Batch.newBuilder().addQueries(QueryOuterClass.BatchQuery.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('streaming_batch_c', 1)").build()).build());
        queryStreamObserver.onCompleted();
        responseRetrieved.await();
    }

    private void executeStreamingInsertQuery() throws InterruptedException {
        final CountDownLatch responseRetrieved = new CountDownLatch(2);
        StreamObserver<QueryOuterClass.StreamingResponse> responseStreamObserver = new StreamObserver<QueryOuterClass.StreamingResponse>(){

            public void onNext(QueryOuterClass.StreamingResponse value) {
                System.out.println("Query streaming response: " + value);
                responseRetrieved.countDown();
            }

            public void onError(Throwable t) {
                System.out.println("Error: " + t);
            }

            public void onCompleted() {
                System.out.println("Query StreamObserver completed");
            }
        };
        StreamObserver queryStreamObserver = this.asyncStub.executeQueryStream((StreamObserver)responseStreamObserver);
        queryStreamObserver.onNext((Object)QueryOuterClass.Query.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('streaming_query', 100)").build());
        queryStreamObserver.onNext((Object)QueryOuterClass.Query.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('streaming_query2', 100)").build());
        queryStreamObserver.onCompleted();
        responseRetrieved.await();
    }

    private void prepareSchema() {
        this.blockingStub.executeQuery(QueryOuterClass.Query.newBuilder().setCql("CREATE KEYSPACE IF NOT EXISTS ks WITH REPLICATION = {'class':'SimpleStrategy', 'replication_factor':'1'};").build());
        this.blockingStub.executeQuery(QueryOuterClass.Query.newBuilder().setCql("CREATE TABLE IF NOT EXISTS ks.test (k text, v int, PRIMARY KEY(k, v))").build());
    }

    public GrpcClientExecuteQuery() {
        ManagedChannel channel = this.createChannel(STARGATE_HOST, 8090);
        this.blockingStub = (StargateGrpc.StargateBlockingStub)((StargateGrpc.StargateBlockingStub)StargateGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(10L, TimeUnit.SECONDS)).withCallCredentials((CallCredentials)new StargateBearerToken(STARGATE_TOKEN));
        this.asyncStub = (StargateGrpc.StargateStub)((StargateGrpc.StargateStub)StargateGrpc.newStub((Channel)channel).withDeadlineAfter(10L, TimeUnit.SECONDS)).withCallCredentials((CallCredentials)new StargateBearerToken(STARGATE_TOKEN));
    }

    public void executeSingleQuery() {
        QueryOuterClass.Response response = this.blockingStub.executeQuery(QueryOuterClass.Query.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('a', 1)").build());
        System.out.println(response);
        response = this.blockingStub.executeQuery(QueryOuterClass.Query.newBuilder().setCql("SELECT k, v FROM ks.test").build());
        QueryOuterClass.ResultSet rs = response.getResultSet();
        System.out.println("k = " + rs.getRows(0).getValues(0).getString());
        System.out.println("v = " + rs.getRows(0).getValues(1).getInt());
    }

    private void executeBatchQueries() {
        QueryOuterClass.Response response = this.blockingStub.executeBatch(QueryOuterClass.Batch.newBuilder().addQueries(QueryOuterClass.BatchQuery.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('a', 1)").build()).addQueries(QueryOuterClass.BatchQuery.newBuilder().setCql("INSERT INTO ks.test (k, v) VALUES ('b', 2)").build()).build());
        System.out.println(response);
        response = this.blockingStub.executeQuery(QueryOuterClass.Query.newBuilder().setCql("SELECT k, v FROM ks.test").build());
        QueryOuterClass.ResultSet rs = response.getResultSet();
        for (QueryOuterClass.Row row : rs.getRowsList()) {
            System.out.println(row.getValuesList());
        }
    }

    private void executeAsyncQueries() throws InterruptedException {
        final CountDownLatch responseRetrieved = new CountDownLatch(1);
        StreamObserver<QueryOuterClass.Response> streamObserver = new StreamObserver<QueryOuterClass.Response>(){

            public void onNext(QueryOuterClass.Response response) {
                System.out.println("Async response: " + response.getResultSet());
                responseRetrieved.countDown();
            }

            public void onError(Throwable throwable) {
                System.out.println("Error: " + throwable);
            }

            public void onCompleted() {
                System.out.println("completed");
            }
        };
        this.asyncStub.executeQuery(QueryOuterClass.Query.newBuilder().setCql("SELECT k, v FROM ks.test").build(), (StreamObserver)streamObserver);
        responseRetrieved.await();
    }

    public ManagedChannel createChannel(String host, int port) {
        return ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }
}

