/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import graphql.GraphQL;
import graphql.GraphqlErrorException;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.common.http.CreateStargateBridgeClient;
import io.stargate.sgv2.graphql.web.models.GraphqlJsonBody;
import io.stargate.sgv2.graphql.web.resources.GraphqlCache;
import io.stargate.sgv2.graphql.web.resources.GraphqlResourceBase;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/graphql")
@Singleton
@CreateStargateBridgeClient
public class DmlResource
extends GraphqlResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(DmlResource.class);
    static final Pattern KEYSPACE_NAME_PATTERN = Pattern.compile("\\w+");
    @Inject
    private GraphqlCache graphqlCache;

    @GET
    public void get(@QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse, @Context StargateBridgeClient bridge) {
        GraphQL graphql = this.getDefaultGraphql(bridge);
        this.get(query, operationName, variables, graphql, httpRequest, asyncResponse, bridge);
    }

    @GET
    @Path(value="/{keyspaceName}")
    public void get(@PathParam(value="keyspaceName") String keyspaceName, @QueryParam(value="query") String query, @QueryParam(value="operationName") String operationName, @QueryParam(value="variables") String variables, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse, @Context StargateBridgeClient bridge) {
        GraphQL graphql = this.getGraphql(keyspaceName, bridge);
        this.get(query, operationName, variables, graphql, httpRequest, asyncResponse, bridge);
    }

    @POST
    @Consumes(value={"application/json"})
    public void postJson(GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse, @Context StargateBridgeClient bridge) {
        GraphQL graphql = this.getDefaultGraphql(bridge);
        this.postJson(jsonBody, queryFromUrl, graphql, httpRequest, asyncResponse, bridge);
    }

    @POST
    @Path(value="/{keyspaceName}")
    @Consumes(value={"application/json"})
    public void postJson(@PathParam(value="keyspaceName") String keyspaceName, GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse, @Context StargateBridgeClient bridge) {
        GraphQL graphql = this.getGraphql(keyspaceName, bridge);
        this.postJson(jsonBody, queryFromUrl, graphql, httpRequest, asyncResponse, bridge);
    }

    @POST
    @Consumes(value={"application/graphql"})
    public void postGraphql(String query, @Context HttpServletRequest httpRequest, @HeaderParam(value="X-Cassandra-Token") String token, @Suspended AsyncResponse asyncResponse, @Context StargateBridgeClient bridge) {
        GraphQL graphql = this.getDefaultGraphql(bridge);
        this.postGraphql(query, graphql, httpRequest, asyncResponse, bridge);
    }

    @POST
    @Path(value="/{keyspaceName}")
    @Consumes(value={"application/graphql"})
    public void postGraphql(@PathParam(value="keyspaceName") String keyspaceName, String query, @Context HttpServletRequest httpRequest, @HeaderParam(value="X-Cassandra-Token") String token, @Suspended AsyncResponse asyncResponse, @Context StargateBridgeClient bridge) {
        GraphQL graphql = this.getGraphql(keyspaceName, bridge);
        this.postGraphql(query, graphql, httpRequest, asyncResponse, bridge);
    }

    private GraphQL getGraphql(String keyspaceName, StargateBridgeClient bridge) {
        if (!KEYSPACE_NAME_PATTERN.matcher(keyspaceName).matches()) {
            LOG.warn("Invalid keyspace in URI, this could be an XSS attack: {}", (Object)keyspaceName);
            throw DmlResource.graphqlError(Response.Status.BAD_REQUEST, "Invalid keyspace name");
        }
        if (!this.isAuthorized(keyspaceName, bridge)) {
            throw DmlResource.graphqlError(Response.Status.UNAUTHORIZED, "Not authorized");
        }
        try {
            String decoratedKeyspaceName = bridge.decorateKeyspaceName(keyspaceName);
            Optional<GraphQL> graphql = this.graphqlCache.getDml(bridge, keyspaceName);
            return graphql.orElseThrow(() -> DmlResource.graphqlError(Response.Status.NOT_FOUND, String.format("Unknown keyspace '%s'", keyspaceName)));
        }
        catch (GraphqlErrorException e) {
            throw DmlResource.graphqlError(Response.Status.INTERNAL_SERVER_ERROR, e);
        }
        catch (Exception e) {
            LOG.error("Unexpected error while accessing keyspace {}", (Object)keyspaceName, (Object)e);
            throw DmlResource.graphqlError(Response.Status.INTERNAL_SERVER_ERROR, "Unexpected error while accessing keyspace: " + e.getMessage());
        }
    }

    private GraphQL getDefaultGraphql(StargateBridgeClient bridge) {
        return this.graphqlCache.getDefaultKeyspaceName(bridge).map(ks -> this.getGraphql((String)ks, bridge)).orElseThrow(() -> DmlResource.graphqlError(Response.Status.NOT_FOUND, "No default keyspace defined"));
    }
}

