/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.types;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.types.TypeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TupleBuilder
extends TypeBuilder {
    private final List<GraphQLType> subTypes;

    public TupleBuilder(List<GraphQLType> subTypes) {
        this.subTypes = subTypes;
    }

    private String getName(boolean isInput) {
        return String.format("Tuple%s%s", this.subTypes.stream().map(this::getTypeName).collect(Collectors.joining()), isInput ? "Input" : "");
    }

    public GraphQLOutputType buildOutputType() {
        ArrayList<GraphQLFieldDefinition> fields = new ArrayList<GraphQLFieldDefinition>(this.subTypes.size());
        for (int i = 0; i < this.subTypes.size(); ++i) {
            fields.add(GraphQLFieldDefinition.newFieldDefinition().name(String.format("item%d", i)).type((GraphQLOutputType)this.subTypes.get(i)).build());
        }
        return GraphQLObjectType.newObject().description(String.format("Represents a Tuple type with %d items", this.subTypes.size())).name(this.getName(false)).fields(fields).build();
    }

    public GraphQLInputType buildInputType() {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>(this.subTypes.size());
        for (int i = 0; i < this.subTypes.size(); ++i) {
            fields.add(GraphQLInputObjectField.newInputObjectField().name(String.format("item%d", i)).type((GraphQLInputType)this.subTypes.get(i)).build());
        }
        return GraphQLInputObjectType.newInputObject().description(String.format("Represents a Tuple input type with %d items", this.subTypes.size())).name(this.getName(true)).fields(fields).build();
    }
}

