/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum FilterOperator {
    EQUAL("eq", Predicate.EQ),
    NOT_EQUAL("notEq", Predicate.NEQ),
    GREATER_THAN("gt", Predicate.GT),
    GREATER_THAN_EQUAL("gte", Predicate.GTE),
    LESS_THAN("lt", Predicate.LT),
    LESS_THAN_EQUAL("lte", Predicate.LTE),
    IN("in", Predicate.IN){

        @Override
        protected Object conditionValue(QueryOuterClass.TypeSpec type, Object graphCQLValue, NameMapping nameMapping) {
            if (graphCQLValue instanceof Collection) {
                Collection values = (Collection)graphCQLValue;
                QueryOuterClass.Value[] elements = (QueryOuterClass.Value[])values.stream().map(item -> DataTypeMapping.toGrpcValue(type, item, nameMapping)).toArray(QueryOuterClass.Value[]::new);
                return Values.of(elements);
            }
            return Collections.singletonList(DataTypeMapping.toGrpcValue(type, graphCQLValue, nameMapping));
        }

        @Override
        public GraphQLInputObjectField buildField(GraphQLInputType gqlInputType) {
            return GraphQLInputObjectField.newInputObjectField().name(this.getFieldName()).type(GraphQLList.list(gqlInputType)).build();
        }
    }
    ,
    CONTAINS("contains", Predicate.CONTAINS){

        @Override
        protected Object conditionValue(QueryOuterClass.TypeSpec type, Object graphCQLValue, NameMapping nameMapping) {
            QueryOuterClass.TypeSpec elementType;
            switch (type.getSpecCase()) {
                case LIST: {
                    elementType = type.getList().getElement();
                    break;
                }
                case SET: {
                    elementType = type.getSet().getElement();
                    break;
                }
                case MAP: {
                    elementType = type.getMap().getValue();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Should not attempt to use CONTAINS with type " + type.getSpecCase()));
                }
            }
            return DataTypeMapping.toGrpcValue(elementType, graphCQLValue, nameMapping);
        }
    }
    ,
    CONTAINS_KEY("containsKey", Predicate.CONTAINS_KEY){

        @Override
        protected Object conditionValue(QueryOuterClass.TypeSpec type, Object graphCQLValue, NameMapping nameMapping) {
            if (type.getSpecCase() != QueryOuterClass.TypeSpec.SpecCase.MAP) {
                throw new AssertionError((Object)("Should not attempt to use CONTAINS_KEY with type " + type.getSpecCase()));
            }
            QueryOuterClass.TypeSpec keyType = type.getMap().getKey();
            return DataTypeMapping.toGrpcValue(keyType, graphCQLValue, nameMapping);
        }
    }
    ,
    CONTAINS_ENTRY("containsEntry", Predicate.EQ){

        private Map<String, Object> entry(Object graphCQLValue) {
            return (Map)graphCQLValue;
        }

        @Override
        protected BuiltCondition.LHS conditionLHS(QueryOuterClass.ColumnSpec column, Object graphCQLValue, NameMapping nameMapping) {
            QueryOuterClass.TypeSpec type = column.getType();
            if (type.getSpecCase() != QueryOuterClass.TypeSpec.SpecCase.MAP) {
                throw new AssertionError((Object)("Should not attempt to use CONTAINS_KEY with type " + type.getSpecCase()));
            }
            QueryOuterClass.TypeSpec keyType = type.getMap().getKey();
            QueryOuterClass.Value key = DataTypeMapping.toGrpcValue(keyType, this.entry(graphCQLValue).get("key"), nameMapping);
            return BuiltCondition.LHS.mapAccess(column.getName(), key);
        }

        @Override
        protected Object conditionValue(QueryOuterClass.TypeSpec type, Object graphCQLValue, NameMapping nameMapping) {
            QueryOuterClass.TypeSpec valueType = type.getMap().getValue();
            return DataTypeMapping.toGrpcValue(valueType, this.entry(graphCQLValue).get("value"), nameMapping);
        }
    };

    private static final Map<String, FilterOperator> mapByFieldName;
    private final String fieldName;
    private final Predicate predicate;

    public static FilterOperator fromFieldName(String fieldName) {
        FilterOperator op = mapByFieldName.get(fieldName);
        if (op == null) {
            throw new IllegalArgumentException("Invalid filter field name: " + fieldName);
        }
        return op;
    }

    private static Map<String, FilterOperator> buildMapByFieldName() {
        return Arrays.stream(FilterOperator.values()).collect(Collectors.toMap(FilterOperator::getFieldName, o -> o));
    }

    public BuiltCondition buildCondition(QueryOuterClass.ColumnSpec column, Object value, NameMapping nameMapping) {
        QueryOuterClass.TypeSpec type = column.getType();
        return BuiltCondition.of(this.conditionLHS(column, value, nameMapping), this.predicate, this.conditionValue(type, value, nameMapping));
    }

    protected BuiltCondition.LHS conditionLHS(QueryOuterClass.ColumnSpec column, Object graphCQLValue, NameMapping nameMapping) {
        return BuiltCondition.LHS.column(column.getName());
    }

    protected Object conditionValue(QueryOuterClass.TypeSpec type, Object graphCQLValue, NameMapping nameMapping) {
        return DataTypeMapping.toGrpcValue(type, graphCQLValue, nameMapping);
    }

    public GraphQLInputObjectField buildField(GraphQLInputType gqlInputType) {
        return GraphQLInputObjectField.newInputObjectField().name(this.fieldName).type(gqlInputType).build();
    }

    private FilterOperator(String fieldName, Predicate predicate) {
        this.fieldName = fieldName;
        this.predicate = predicate;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    static {
        mapByFieldName = FilterOperator.buildMapByFieldName();
    }
}

