/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.protobuf.Int32Value;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.grpc.BytesValues;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.common.grpc.proto.Rows;
import io.stargate.sgv2.graphql.schema.CassandraFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DbColumnGetter;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.FilterOperator;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmlFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    private static final Logger LOG = LoggerFactory.getLogger(DmlFetcher.class);
    protected final String keyspaceName;
    protected final Schema.CqlTable table;
    protected final NameMapping nameMapping;
    protected final DbColumnGetter dbColumnGetter;

    protected DmlFetcher(String keyspaceName, Schema.CqlTable table, NameMapping nameMapping) {
        this.keyspaceName = keyspaceName;
        this.table = table;
        this.nameMapping = nameMapping;
        this.dbColumnGetter = new DbColumnGetter(nameMapping);
    }

    protected QueryOuterClass.QueryParameters buildParameters(DataFetchingEnvironment environment) {
        Object pageState;
        Object pageSize;
        Object serialConsistency;
        Map options = (Map)environment.getArgument("options");
        if (options == null) {
            return DEFAULT_PARAMETERS;
        }
        QueryOuterClass.QueryParameters.Builder builder = DEFAULT_PARAMETERS.toBuilder();
        Object consistency = options.get("consistency");
        if (consistency != null) {
            builder.setConsistency(QueryOuterClass.ConsistencyValue.newBuilder().setValue(QueryOuterClass.Consistency.valueOf((String)consistency)));
        }
        if ((serialConsistency = options.get("serialConsistency")) != null) {
            builder.setSerialConsistency(QueryOuterClass.ConsistencyValue.newBuilder().setValue(QueryOuterClass.Consistency.valueOf((String)serialConsistency)));
        }
        if ((pageSize = options.get("pageSize")) != null) {
            builder.setPageSize(Int32Value.of((Integer)pageSize));
        }
        if ((pageState = options.get("pageState")) != null) {
            builder.setPagingState(BytesValues.ofBase64((String)pageState));
        }
        return builder.build();
    }

    protected List<BuiltCondition> buildConditions(Map<String, Map<String, Object>> columnList) {
        if (columnList == null) {
            return ImmutableList.of();
        }
        ArrayList<BuiltCondition> where = new ArrayList<BuiltCondition>();
        for (Map.Entry<String, Map<String, Object>> clauseEntry : columnList.entrySet()) {
            QueryOuterClass.ColumnSpec column = this.dbColumnGetter.getColumn(this.table, clauseEntry.getKey());
            for (Map.Entry<String, Object> condition : clauseEntry.getValue().entrySet()) {
                FilterOperator operator = FilterOperator.fromFieldName(condition.getKey());
                where.add(operator.buildCondition(column, condition.getValue(), this.nameMapping));
            }
        }
        return where;
    }

    protected List<BuiltCondition> buildClause(Schema.CqlTable table, DataFetchingEnvironment environment) {
        if (environment.containsArgument("filter")) {
            Map columnList = (Map)environment.getArgument("filter");
            return this.buildConditions(columnList);
        }
        Map value = (Map)environment.getArgument("value");
        if (value == null) {
            return ImmutableList.of();
        }
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        for (Map.Entry entry : value.entrySet()) {
            QueryOuterClass.ColumnSpec column = this.dbColumnGetter.getColumn(table, (String)entry.getKey());
            QueryOuterClass.Value whereValue = this.toGrpcValue(column.getType(), entry.getValue());
            relations.add(BuiltCondition.of(column.getName(), Predicate.EQ, (Object)whereValue));
        }
        return relations;
    }

    protected boolean containsDirective(OperationDefinition operation, String directive) {
        return operation.getDirectives().stream().anyMatch(d -> d.getName().equals(directive));
    }

    protected CompletableFuture<Map<String, Object>> executeAsyncAccepted(QueryOuterClass.Query query, Object originalValue, StargateGraphqlContext context) {
        context.getBridge().executeQueryAsync(query).whenComplete((r, throwable) -> {
            if (throwable != null) {
                LOG.warn(String.format("The query %s executed within the %s directive failed.", query, "async"), (Throwable)throwable);
            }
        });
        return CompletableFuture.completedFuture(this.toAcceptedMutationResult(originalValue));
    }

    protected ImmutableMap<String, Object> toAcceptedMutationResult(Object originalValue) {
        return ImmutableMap.of("value", originalValue, "accepted", true);
    }

    protected CompletionStage<List<Map<String, Object>>> toListOfAcceptedMutationResults(List<Map<String, Object>> originalValues) {
        ArrayList<ImmutableMap<String, Object>> results = new ArrayList<ImmutableMap<String, Object>>();
        for (Map<String, Object> originalValue : originalValues) {
            results.add(this.toAcceptedMutationResult(originalValue));
        }
        return CompletableFuture.completedFuture(results);
    }

    protected Map<String, Object> toMutationResult(QueryOuterClass.Response response, Object originalValue) {
        QueryOuterClass.ResultSet resultSet = response.getResultSet();
        if (resultSet.getRowsCount() == 0) {
            return ImmutableMap.of("value", originalValue, "applied", true);
        }
        return this.toMutationResultSingleRow(originalValue, resultSet.getRows(0), resultSet.getColumnsList());
    }

    private ImmutableMap<String, Object> toMutationResultSingleRow(Object originalValue, QueryOuterClass.Row row, List<QueryOuterClass.ColumnSpec> columns) {
        boolean applied = this.isApplied(row, columns);
        Map<String, Object> finalValue = applied ? originalValue : DataTypeMapping.toGraphqlValue(this.nameMapping, this.table, columns, row);
        return ImmutableMap.of("value", finalValue, "applied", applied);
    }

    protected Map<String, Object> toBatchResult(QueryOuterClass.Response response, Map<String, Object> originalValue) {
        QueryOuterClass.ResultSet resultSet = response.getResultSet();
        if (this.isApplied(resultSet)) {
            return ImmutableMap.of("value", originalValue, "applied", true);
        }
        return this.toUnappliedBatchResult(resultSet, originalValue);
    }

    protected List<Map<String, Object>> toBatchResults(QueryOuterClass.Response response, List<Map<String, Object>> originalValues) {
        QueryOuterClass.ResultSet resultSet = response.getResultSet();
        boolean applied = this.isApplied(resultSet);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> originalValue : originalValues) {
            results.add(applied ? ImmutableMap.of("value", originalValue, "applied", true) : this.toUnappliedBatchResult(resultSet, originalValue));
        }
        return results;
    }

    private Map<String, Object> toUnappliedBatchResult(QueryOuterClass.ResultSet resultSet, Map<String, Object> originalValue) {
        Map<String, QueryOuterClass.Value> primaryKey = Streams.concat(this.table.getPartitionKeyColumnsList().stream(), this.table.getClusteringKeyColumnsList().stream()).collect(Collectors.toMap(QueryOuterClass.ColumnSpec::getName, c -> this.toGrpcValue(c.getType(), originalValue.get(this.nameMapping.getGraphqlName(this.table, (QueryOuterClass.ColumnSpec)c)))));
        List<QueryOuterClass.ColumnSpec> columns = resultSet.getColumnsList();
        return resultSet.getRowsList().stream().filter(row -> this.matches((QueryOuterClass.Row)row, primaryKey, columns)).findFirst().map(row -> ImmutableMap.of("applied", false, "value", DataTypeMapping.toGraphqlValue(this.nameMapping, this.table, columns, row))).orElse(ImmutableMap.of("applied", false));
    }

    private boolean matches(QueryOuterClass.Row row, Map<String, QueryOuterClass.Value> primaryKey, List<QueryOuterClass.ColumnSpec> columns) {
        for (Map.Entry<String, QueryOuterClass.Value> entry : primaryKey.entrySet()) {
            String name = entry.getKey();
            QueryOuterClass.Value value = entry.getValue();
            int i = Rows.firstIndexOf(name, columns);
            if (i >= 0 && value.equals(row.getValues(i))) continue;
            return false;
        }
        return true;
    }

    protected QueryOuterClass.Value toGrpcValue(QueryOuterClass.TypeSpec type, Object value) {
        return DataTypeMapping.toGrpcValue(type, value, this.nameMapping);
    }

    protected Integer getTtl(DataFetchingEnvironment environment) {
        Map options = (Map)environment.getArgument("options");
        return options == null ? null : (Integer)options.get("ttl");
    }
}

