/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml;

import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.util.HashMap;
import java.util.Map;

abstract class FieldTypeCache<GraphqlT> {
    protected final NameMapping nameMapping;
    private final Map<QueryOuterClass.TypeSpec, GraphqlT> types = new HashMap<QueryOuterClass.TypeSpec, GraphqlT>();

    FieldTypeCache(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    GraphqlT get(QueryOuterClass.TypeSpec type) {
        type = this.normalize(type);
        return this.computeIfAbsent(type);
    }

    private GraphqlT computeIfAbsent(QueryOuterClass.TypeSpec type) {
        GraphqlT result = this.types.get(type);
        if (result == null) {
            result = this.compute(type);
            this.types.put(type, result);
        }
        return result;
    }

    private QueryOuterClass.TypeSpec normalize(QueryOuterClass.TypeSpec type) {
        switch (type.getSpecCase()) {
            case MAP: {
                QueryOuterClass.TypeSpec.Map map = type.getMap();
                if (!map.getFrozen()) {
                    return type;
                }
                return QueryOuterClass.TypeSpec.newBuilder().setMap(QueryOuterClass.TypeSpec.Map.newBuilder(map).setFrozen(false).build()).build();
            }
            case LIST: {
                QueryOuterClass.TypeSpec.List list = type.getList();
                if (!list.getFrozen()) {
                    return type;
                }
                return QueryOuterClass.TypeSpec.newBuilder().setList(QueryOuterClass.TypeSpec.List.newBuilder(list).setFrozen(false).build()).build();
            }
            case SET: {
                QueryOuterClass.TypeSpec.Set set = type.getSet();
                return QueryOuterClass.TypeSpec.newBuilder().setList(QueryOuterClass.TypeSpec.List.newBuilder().setElement(set.getElement()).build()).build();
            }
            case UDT: {
                QueryOuterClass.TypeSpec.Udt udt = type.getUdt();
                if (!udt.getFrozen()) {
                    return type;
                }
                return QueryOuterClass.TypeSpec.newBuilder().setUdt(QueryOuterClass.TypeSpec.Udt.newBuilder(udt).setFrozen(false).build()).build();
            }
        }
        return type;
    }

    protected abstract GraphqlT compute(QueryOuterClass.TypeSpec var1);

    protected GraphQLScalarType getScalar(QueryOuterClass.TypeSpec.Basic type) {
        switch (type) {
            case BOOLEAN: {
                return Scalars.GraphQLBoolean;
            }
            case DOUBLE: {
                return Scalars.GraphQLFloat;
            }
            case INT: {
                return Scalars.GraphQLInt;
            }
            case VARCHAR: {
                return Scalars.GraphQLString;
            }
        }
        return CqlScalar.fromCqlType(type).orElseThrow(() -> new IllegalArgumentException("Unsupported CQL type " + type)).getGraphqlType();
    }
}

