/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.common.cql.builder.Replication;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.DdlQueryFetcher;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateKeyspaceFetcher
extends DdlQueryFetcher {
    @Override
    protected QueryOuterClass.Query buildQuery(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        String keyspaceName = (String)environment.getArgument("name");
        boolean ifNotExists = environment.getArgumentOrDefault("ifNotExists", Boolean.FALSE);
        Integer replicas = (Integer)environment.getArgument("replicas");
        List datacenters = (List)environment.getArgument("datacenters");
        if (replicas == null && datacenters == null) {
            throw new IllegalArgumentException("You must specify either replicas or datacenters");
        }
        if (replicas != null && datacenters != null) {
            throw new IllegalArgumentException("You can't specify both replicas and datacenters");
        }
        Replication replication = replicas != null ? Replication.simpleStrategy(replicas) : Replication.networkTopologyStrategy(this.parseDatacenters(datacenters));
        return new QueryBuilder().create().keyspace(keyspaceName).ifNotExists(ifNotExists).withReplication(replication).build();
    }

    private Map<String, Integer> parseDatacenters(List<Map<String, Object>> datacenters) {
        assert (datacenters != null);
        if (datacenters.isEmpty()) {
            throw new IllegalArgumentException("datacenters must contain at least one element");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map<String, Object> datacenter : datacenters) {
            String dcName = (String)datacenter.get("name");
            Integer dcReplicas = (Integer)datacenter.getOrDefault("replicas", 3);
            result.put(dcName, dcReplicas);
        }
        return result;
    }
}

