/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.CollectionIndexingType;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.IndexFetcher;

public class CreateIndexFetcher
extends IndexFetcher {
    @Override
    protected QueryOuterClass.Query buildQuery(DataFetchingEnvironment environment, String keyspaceName, String tableName) {
        String columnName = (String)environment.getArgument("columnName");
        String indexName = (String)environment.getArgument("indexName");
        boolean ifNotExists = environment.getArgumentOrDefault("ifNotExists", Boolean.FALSE);
        String customIndexClass = environment.getArgumentOrDefault("indexType", null);
        String indexKind = environment.getArgumentOrDefault("indexKind", null);
        CollectionIndexingType indexingType = this.convertIndexingType(indexKind);
        return new QueryBuilder().create().index(indexName).ifNotExists(ifNotExists).on(keyspaceName, tableName).column(columnName).indexingType(indexingType).custom(customIndexClass).build();
    }

    private CollectionIndexingType convertIndexingType(String spec) {
        if (spec != null) {
            switch (spec) {
                case "KEYS": {
                    return CollectionIndexingType.KEYS;
                }
                case "VALUES": {
                    return CollectionIndexingType.VALUES;
                }
                case "ENTRIES": {
                    return CollectionIndexingType.ENTRIES;
                }
                case "FULL": {
                    return CollectionIndexingType.FULL;
                }
            }
            throw new IllegalArgumentException(String.format("Invalid indexKind value: %s", spec));
        }
        return null;
    }
}

