/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.impl;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.help.cli.CliCommandUsageGenerator;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.errors.ParseException;
import io.stargate.core.metrics.api.NoopHttpMetricsTagProvider;
import io.stargate.core.metrics.impl.MetricsImpl;
import io.stargate.sgv2.graphql.impl.GraphqlServiceServer;
import java.io.IOError;
import java.io.IOException;

@Command(name="sgv2-graphqlapi")
public class GraphqlServiceStarter {
    @Option(name={"--disable-playground"}, title={"disable-playground"}, description="whether to disable the GraphQL Playground UI (exposed at /playground)")
    private boolean disablePlayground;
    @Option(name={"--disable-default-keyspace"}, title={"disable-playground"}, description="whether to disable the \"default keyspace\" feature (which consists in falling back to the oldest keyspace if not specified in the URL path)")
    private boolean disableDefaultKeyspace;

    public void start() throws Exception {
        MetricsImpl metricsImpl = new MetricsImpl();
        NoopHttpMetricsTagProvider httpMetricsTags = new NoopHttpMetricsTagProvider();
        GraphqlServiceServer server = new GraphqlServiceServer(metricsImpl, metricsImpl, httpMetricsTags, this.disablePlayground, this.disableDefaultKeyspace);
        server.run("server", "config.yaml");
    }

    public static void main(String[] args) {
        GraphqlServiceStarter.cli(args, GraphqlServiceStarter.class);
    }

    protected static void printHelp(SingleCommand<?> c) {
        try {
            new CliCommandUsageGenerator(79).usage(c.getCommandMetadata(), c.getParserConfiguration(), System.err);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected static void cli(String[] args, Class<? extends GraphqlServiceStarter> starterClass) {
        SingleCommand<? extends GraphqlServiceStarter> parser = SingleCommand.singleCommand(starterClass);
        try {
            ParseResult<? extends GraphqlServiceStarter> result = parser.parseWithResult(args);
            if (result.wasSuccessful()) {
                result.getCommand().start();
            } else {
                GraphqlServiceStarter.printHelp(parser);
                System.err.println();
                System.err.printf("%d errors encountered:%n", result.getErrors().size());
                int i = 1;
                for (ParseException e : result.getErrors()) {
                    System.err.printf("Error %d: %s%n", i, e.getMessage());
                    ++i;
                }
                System.err.println();
            }
        }
        catch (ParseException p) {
            GraphqlServiceStarter.printHelp(parser);
            if (args.length <= 0 || !args[0].equals("-h") && !args[0].equals("--help")) {
                System.err.println();
                System.err.printf("Usage error: %s%n", p.getMessage());
                System.err.println();
            }
        }
        catch (Exception e) {
            System.err.printf("Unexpected error: %s%n", e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

