/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.impl;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.ContextRoutingHandler;
import io.dropwizard.server.SimpleServerFactory;
import io.dropwizard.setup.Environment;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="sgv2-graphql-service")
public class GraphqlServiceServerFactory
extends SimpleServerFactory {
    @Override
    public Server build(Environment environment) {
        this.configure(environment);
        this.printBanner(environment.getName());
        ThreadPool threadPool = this.createThreadPool(environment.metrics());
        Server server = this.buildServer(environment.lifecycle(), threadPool);
        Handler applicationHandler = this.createAppServlet(server, environment.jersey(), environment.getObjectMapper(), environment.getValidator(), environment.getApplicationContext(), environment.getJerseyServletContainer(), environment.metrics());
        Connector conn = this.getConnector().build(server, environment.metrics(), environment.getName(), null);
        server.addConnector(conn);
        Map<String, Handler> handlers = Collections.singletonMap(this.getApplicationContextPath(), applicationHandler);
        ContextRoutingHandler routingHandler = new ContextRoutingHandler(handlers);
        Handler gzipHandler = this.buildGzipHandler(routingHandler);
        server.setHandler(this.addStatsHandler(this.addRequestLog(server, gzipHandler, environment.getName())));
        return server;
    }

    @Override
    public void configure(Environment environment) {
        environment.getApplicationContext().setContextPath(this.getApplicationContextPath());
    }
}

