/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql.builder;

import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.ColumnUtils;
import io.stargate.sgv2.common.cql.CqlStrings;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.CollectionIndexingType;
import io.stargate.sgv2.common.cql.builder.Column;
import io.stargate.sgv2.common.cql.builder.ImmutableColumn;
import io.stargate.sgv2.common.cql.builder.Literal;
import io.stargate.sgv2.common.cql.builder.Marker;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.common.cql.builder.Replication;
import io.stargate.sgv2.common.cql.builder.Term;
import io.stargate.sgv2.common.cql.builder.ValueModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryBuilderImpl {
    private boolean isCreate;
    private boolean isAlter;
    private boolean isInsert;
    private boolean isUpdate;
    private boolean isDelete;
    private boolean isSelect;
    private boolean isDrop;
    private boolean isKeyspace;
    private boolean isTable;
    private boolean isMaterializedView;
    private boolean isType;
    private boolean isIndex;
    private boolean isTruncate;
    private CollectionIndexingType indexingType;
    private String keyspaceName;
    private String tableName;
    private String indexName;
    private String typeName;
    private final List<Column> createColumns = new ArrayList<Column>();
    private final List<Column> addColumns = new ArrayList<Column>();
    private final List<String> dropColumns = new ArrayList<String>();
    private final Map<String, String> columnRenames = new LinkedHashMap<String, String>();
    private final List<ValueModifier> dmlModifications = new ArrayList<ValueModifier>();
    private final List<String> selection = new ArrayList<String>();
    private final List<FunctionCall> functionCalls = new ArrayList<FunctionCall>();
    private final List<BuiltCondition> wheres = new ArrayList<BuiltCondition>();
    private final List<BuiltCondition> ifs = new ArrayList<BuiltCondition>();
    private Term limit;
    private Term perPartitionLimit;
    private final List<String> groupBys = new ArrayList<String>();
    private final Map<String, Column.Order> orders = new LinkedHashMap<String, Column.Order>();
    private final Map<Marker, QueryOuterClass.Value> markers = new HashMap<Marker, QueryOuterClass.Value>();
    private final List<QueryOuterClass.Value> boundValues = new ArrayList<QueryOuterClass.Value>();
    private Replication replication;
    private boolean ifNotExists;
    private boolean ifExists;
    private Boolean durableWrites;
    private String comment;
    private Integer defaultTTL;
    private String indexCreateColumn;
    private String customIndexClass;
    private Map<String, String> customIndexOptions;
    private Term ttl;
    private Term timestamp;
    private boolean allowFiltering;
    private QueryOuterClass.QueryParameters parameters;

    public void create() {
        this.isCreate = true;
    }

    public void alter() {
        this.isAlter = true;
    }

    public void drop() {
        this.isDrop = true;
    }

    public void truncate() {
        this.isTruncate = true;
    }

    public void keyspace(String keyspace) {
        this.keyspaceName = keyspace;
        this.isKeyspace = true;
    }

    public void table(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.table(table);
    }

    public void table(String table) {
        this.tableName = table;
        this.isTable = true;
    }

    public void withReplication(Replication replication) {
        this.replication = replication;
    }

    public void andDurableWrites(boolean durableWrites) {
        this.durableWrites = durableWrites;
    }

    public void ifNotExists() {
        this.ifNotExists(true);
    }

    public void ifNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void ifExists() {
        this.ifExists(true);
    }

    public void ifExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public void withComment(String comment) {
        this.comment = comment;
    }

    public void withDefaultTTL(int defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void column(String column) {
        if (this.isCreate) {
            if (this.isTable || this.isType) {
                throw QueryBuilderImpl.invalid("Column '%s' type must be specified for a table or type creation", new Object[0]);
            }
            if (this.isMaterializedView) {
                this.createColumns.add(Column.reference(column));
                return;
            } else {
                if (!this.isIndex) throw new AssertionError((Object)"This shouldn't have been called");
                this.indexCreateColumn = column;
            }
            return;
        } else {
            if (!this.isSelect && !this.isDelete) throw new AssertionError((Object)"This shouldn't have been called");
            this.selection.add(column);
        }
    }

    public void column(String ... columns) {
        for (String c : columns) {
            this.column(c);
        }
    }

    public void column(Column column) {
        if (this.isCreate) {
            if ((this.isTable || this.isType) && column.type() == null) {
                throw QueryBuilderImpl.invalid("Column '%s' type must be specified for a table or type creation", new Object[0]);
            }
            this.createColumns.add(column);
        } else {
            this.column(column.name());
        }
    }

    public void column(Collection<Column> columns) {
        for (Column c : columns) {
            this.column(c);
        }
    }

    public void column(String column, String type, Column.Kind kind) {
        this.column(ImmutableColumn.builder().name(column).type(type).kind(kind).build());
    }

    public void column(String column, String type, Column.Kind kind, Column.Order order) {
        this.column(ImmutableColumn.builder().name(column).type(type).kind(kind).order(order).build());
    }

    public void column(String column, Column.Kind kind) {
        this.column(ImmutableColumn.builder().name(column).kind(kind).build());
    }

    public void column(String column, Column.Kind kind, Column.Order order) {
        this.column(ImmutableColumn.builder().name(column).kind(kind).order(order).build());
    }

    public void column(String column, String type) {
        this.column(column, type, Column.Kind.REGULAR);
    }

    public void as(String alias) {
        if (this.functionCalls.isEmpty()) {
            throw new IllegalStateException("The as() method cannot be called without a preceding function call.");
        }
        FunctionCall functionCall = this.functionCalls.get(this.functionCalls.size() - 1);
        functionCall.setAlias(alias);
    }

    public void writeTimeColumn(String columnName) {
        this.functionCalls.add(FunctionCall.writeTime(columnName));
    }

    public void writeTimeColumn(Column columnName) {
        this.writeTimeColumn(columnName.name());
    }

    public void count(String columnName) {
        this.functionCalls.add(FunctionCall.count(columnName));
    }

    public void count(Column columnName) {
        this.count(columnName.name());
    }

    public void max(String maxColumnName) {
        this.functionCalls.add(FunctionCall.max(maxColumnName));
    }

    public void max(Column maxColumnName) {
        this.max(maxColumnName.name());
    }

    public void min(String minColumnName) {
        this.functionCalls.add(FunctionCall.min(minColumnName));
    }

    public void min(Column minColumnName) {
        this.min(minColumnName.name());
    }

    public void sum(String sumColumnName) {
        this.functionCalls.add(FunctionCall.sum(sumColumnName));
    }

    public void sum(Column sumColumnName) {
        this.sum(sumColumnName.name());
    }

    public void avg(String avgColumnName) {
        this.functionCalls.add(FunctionCall.avg(avgColumnName));
    }

    public void avg(Column avgColumnName) {
        this.avg(avgColumnName.name());
    }

    public void function(Collection<FunctionCall> calls) {
        this.functionCalls.addAll(calls);
    }

    public void star() {
        if (!this.selection.isEmpty()) {
            throw QueryBuilderImpl.invalid("Cannot use * when other columns are selected", new Object[0]);
        }
    }

    public void addColumn(String column, String type) {
        this.addColumn(ImmutableColumn.builder().name(column).type(type).kind(Column.Kind.REGULAR).build());
    }

    public void addColumn(Column column) {
        this.addColumns.add(column);
    }

    public void addColumn(Collection<Column> columns) {
        for (Column column : columns) {
            this.addColumn(column);
        }
    }

    public void dropColumn(String column) {
        this.dropColumns.add(column);
    }

    public void dropColumn(Collection<String> columns) {
        for (String column : columns) {
            this.dropColumn(column);
        }
    }

    public void dropColumn(Column column) {
        this.dropColumn(column.name());
    }

    public void renameColumn(String from, String to) {
        this.columnRenames.put(from, to);
    }

    public void renameColumn(Map<String, String> columnRenames) {
        this.columnRenames.putAll(columnRenames);
    }

    public void insertInto(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.tableName = table;
        this.isInsert = true;
    }

    public void insertInto(String table) {
        this.insertInto(null, table);
    }

    public void update(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.tableName = table;
        this.isUpdate = true;
    }

    public void update(String table) {
        this.update(null, table);
    }

    public void delete() {
        this.isDelete = true;
    }

    public void select() {
        this.isSelect = true;
    }

    public void from(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.from(table);
    }

    public void from(String table) {
        this.tableName = table;
    }

    public void value(String column, Object value) {
        this.addModifier(ValueModifier.set(column, this.termFor(value)));
    }

    public void value(Column column, Object value) {
        this.value(column.name(), value);
    }

    public void value(ValueModifier modifier) {
        Term newValue = this.bindGrpcValues(modifier.value());
        ValueModifier.Target newTarget = this.bindGrpcValues(modifier.target());
        if (newValue != modifier.value() || newTarget != modifier.target()) {
            modifier = ValueModifier.of(newTarget, modifier.operation(), newValue);
        }
        this.addModifier(modifier);
    }

    private void addModifier(ValueModifier modifier) {
        if (this.isInsert && (modifier.target().fieldName() != null || modifier.target().mapKey() != null)) {
            throw QueryBuilderImpl.invalid("Can't reference fields or map elements in INSERT queries", new Object[0]);
        }
        this.dmlModifications.add(modifier);
    }

    public void value(Collection<ValueModifier> setters) {
        for (ValueModifier setter : setters) {
            this.value(setter);
        }
    }

    public void where(Column column, Predicate predicate, Object value) {
        this.where(column.name(), predicate, value);
    }

    public void where(String columnName, Predicate predicate, Object value) {
        this.where(BuiltCondition.of(columnName, predicate, this.termFor(value)));
    }

    public void where(BuiltCondition where) {
        this.addWhere(this.bindGrpcValues(where));
    }

    private void addWhere(BuiltCondition where) {
        this.wheres.add(where);
    }

    public void where(Collection<? extends BuiltCondition> where) {
        for (BuiltCondition builtCondition : where) {
            this.where(builtCondition);
        }
    }

    public void ifs(String columnName, Predicate predicate, Object value) {
        this.addIf(BuiltCondition.of(columnName, predicate, this.termFor(value)));
    }

    public void ifs(BuiltCondition condition) {
        this.addIf(this.bindGrpcValues(condition));
    }

    private void addIf(BuiltCondition condition) {
        this.ifs.add(condition);
    }

    public void ifs(Collection<? extends BuiltCondition> conditions) {
        for (BuiltCondition builtCondition : conditions) {
            this.ifs(builtCondition);
        }
    }

    public void materializedView(String keyspace, String name) {
        this.keyspaceName = keyspace;
        this.materializedView(name);
    }

    public void materializedView(String name) {
        this.indexName = name;
        this.isMaterializedView = true;
    }

    public void asSelect() {
    }

    public void on(String keyspace, String table) {
        this.keyspaceName = keyspace;
        this.on(table);
    }

    public void on(String table) {
        this.tableName = table;
    }

    public void index(String index) {
        this.indexName = index;
        this.isIndex = true;
    }

    public void index() {
        this.index(null);
    }

    public void index(String keyspace, String index) {
        this.keyspaceName = keyspace;
        this.index(index);
    }

    public void indexingType(CollectionIndexingType indexingType) {
        this.indexingType = indexingType;
    }

    public void indexKeys() {
        this.indexingType(CollectionIndexingType.KEYS);
    }

    public void indexValues() {
        this.indexingType(CollectionIndexingType.VALUES);
    }

    public void indexEntries() {
        this.indexingType(CollectionIndexingType.ENTRIES);
    }

    public void indexFull() {
        this.indexingType(CollectionIndexingType.FULL);
    }

    public void custom(String customIndexClass) {
        this.customIndexClass = customIndexClass;
    }

    public void custom(String customIndexClass, Map<String, String> customIndexOptions) {
        this.custom(customIndexClass);
        this.customIndexOptions = customIndexOptions;
    }

    public void options(Map<String, String> customIndexOptions) {
        this.customIndexOptions = customIndexOptions;
    }

    public void type(String keyspace, String typeName) {
        this.keyspaceName = keyspace;
        this.typeName = typeName;
        this.isType = true;
    }

    public void limit(Integer limit) {
        if (limit != null) {
            this.limit = Term.of(limit);
        }
    }

    public void limit(QueryOuterClass.Value limit) {
        if (limit != null) {
            if (limit.getInnerCase() != QueryOuterClass.Value.InnerCase.INT) {
                throw new IllegalArgumentException("Expected an int value");
            }
            this.limit = this.termFor(limit);
        }
    }

    public void perPartitionLimit(Integer limit) {
        if (limit != null) {
            this.perPartitionLimit = Term.of(limit);
        }
    }

    public void perPartitionLimit(QueryOuterClass.Value limit) {
        if (limit != null) {
            if (limit.getInnerCase() != QueryOuterClass.Value.InnerCase.INT) {
                throw new IllegalArgumentException("Expected an int value");
            }
            this.perPartitionLimit = this.termFor(limit);
        }
    }

    public void groupBy(String name) {
        this.groupBys.add(name);
    }

    public void groupBy(Iterable<String> columns) {
        columns.forEach(this::groupBy);
    }

    public void orderBy(Column column, Column.Order order) {
        this.orderBy(column.name(), order);
    }

    public void orderBy(String column, Column.Order order) {
        this.orders.put(column, order);
    }

    public void orderBy(Map<String, Column.Order> orders) {
        this.orders.clear();
        this.orders.putAll(orders);
    }

    public void allowFiltering() {
        this.allowFiltering = true;
    }

    public void allowFiltering(boolean allowFiltering) {
        this.allowFiltering = allowFiltering;
    }

    public void ttl(Integer ttl) {
        if (ttl != null) {
            this.ttl = Term.of(ttl);
        }
    }

    public void ttl(QueryOuterClass.Value ttl) {
        if (ttl != null) {
            if (ttl.getInnerCase() != QueryOuterClass.Value.InnerCase.INT) {
                throw new IllegalArgumentException("Expected an int value");
            }
            this.ttl = this.termFor(ttl);
        }
    }

    public void timestamp(Long timestamp) {
        if (timestamp != null) {
            this.timestamp = Term.of(timestamp);
        }
    }

    public void timestamp(QueryOuterClass.Value timestamp) {
        if (timestamp != null) {
            if (timestamp.getInnerCase() != QueryOuterClass.Value.InnerCase.INT) {
                throw new IllegalArgumentException("Expected an int value");
            }
            this.timestamp = this.termFor(timestamp);
        }
    }

    public void parameters(QueryOuterClass.QueryParameters parameters) {
        this.parameters = parameters;
    }

    public QueryOuterClass.Query build() {
        QueryOuterClass.Query.Builder query = QueryOuterClass.Query.newBuilder().setCql(this.buildCql());
        if (!this.boundValues.isEmpty()) {
            query.setValues(QueryOuterClass.Values.newBuilder().addAllValues(this.boundValues).build());
        }
        if (this.parameters != null) {
            query.setParameters(this.parameters);
        }
        return query.build();
    }

    private String buildCql() {
        if (this.isKeyspace && this.isCreate) {
            return this.createKeyspace();
        }
        if (this.isKeyspace && this.isAlter) {
            return this.alterKeyspace();
        }
        if (this.isKeyspace && this.isDrop) {
            return this.dropKeyspace();
        }
        if (this.isTable && this.isCreate) {
            return this.createTable();
        }
        if (this.isTable && this.isAlter) {
            return this.alterTable();
        }
        if (this.isTable && this.isDrop) {
            return this.dropTable();
        }
        if (this.isTable && this.isTruncate) {
            return this.truncateTable();
        }
        if (this.isIndex && this.isCreate) {
            return this.createIndex();
        }
        if (this.isIndex && this.isDrop) {
            return this.dropIndex();
        }
        if (this.isMaterializedView && this.isCreate) {
            return this.createMaterializedView();
        }
        if (this.isMaterializedView && this.isDrop) {
            return this.dropMaterializedView();
        }
        if (this.isType && this.isCreate) {
            return this.createType();
        }
        if (this.isType && this.isDrop) {
            return this.dropType();
        }
        if (this.isType && this.isAlter) {
            if (!this.columnRenames.isEmpty()) {
                return this.renameTypeColumns();
            }
            return this.alterType();
        }
        if (this.isInsert) {
            return this.insertQuery();
        }
        if (this.isUpdate) {
            return this.updateQuery();
        }
        if (this.isDelete) {
            return this.deleteQuery();
        }
        if (this.isSelect) {
            return this.selectQuery();
        }
        throw new AssertionError((Object)"Unknown query type");
    }

    private static IllegalArgumentException invalid(String format, Object ... args) {
        return new IllegalArgumentException(String.format(format, args));
    }

    private static String cqlName(String name) {
        return ColumnUtils.maybeQuote(name);
    }

    private String createKeyspace() {
        StringBuilder query = new StringBuilder("CREATE KEYSPACE ");
        String ksName = QueryBuilderImpl.cqlName(this.keyspaceName);
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        }
        query.append(ksName);
        query.append(" WITH replication = ").append(this.replication);
        if (this.durableWrites != null) {
            query.append(" AND durable_writes = ").append(this.durableWrites);
        }
        return query.toString();
    }

    private String alterKeyspace() {
        StringBuilder query = new StringBuilder("ALTER KEYSPACE ").append(QueryBuilderImpl.cqlName(this.keyspaceName));
        WithAdder with = new WithAdder(query);
        if (this.replication != null) {
            with.add().append(" replication = ").append(this.replication);
        }
        if (this.durableWrites != null) {
            with.add().append(" durable_writes = ").append(this.durableWrites);
        }
        return query.toString();
    }

    private String dropKeyspace() {
        StringBuilder query = new StringBuilder("DROP KEYSPACE ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        }
        query.append(QueryBuilderImpl.cqlName(this.keyspaceName));
        return query.toString();
    }

    private void addPrimaryKey(StringBuilder query, List<Column> columns, String name) {
        if (columns.stream().noneMatch(c -> c.kind() == Column.Kind.valueOf(Column.Kind.PARTITION_KEY.name()))) {
            throw QueryBuilderImpl.invalid("At least one partition key must be specified for table or materialized view '%s' %s", name, Arrays.deepToString(columns.toArray()));
        }
        query.append("PRIMARY KEY (").append(columns.stream().filter(c -> c.kind() == Column.Kind.PARTITION_KEY).map(Column::cqlName).collect(Collectors.joining(", ", "(", ")")));
        if (columns.stream().anyMatch(c -> c.kind() == Column.Kind.CLUSTERING)) {
            query.append(", ");
        }
        query.append(columns.stream().filter(c -> c.kind() == Column.Kind.CLUSTERING).map(Column::cqlName).collect(Collectors.joining(", "))).append(")");
    }

    private void addClusteringOrder(WithAdder with, List<Column> columns) {
        if (columns.stream().anyMatch(c -> c.kind() == Column.Kind.CLUSTERING && c.order() != null)) {
            StringBuilder query = with.add();
            query.append(columns.stream().filter(c -> c.kind() == Column.Kind.CLUSTERING).map(c -> c.cqlName() + " " + c.order().name().toUpperCase()).collect(Collectors.joining(", ", " CLUSTERING ORDER BY (", ")")));
        }
    }

    private void addComment(WithAdder with) {
        if (this.comment != null) {
            String quotedComment = CqlStrings.quote(this.comment);
            with.add().append(" comment = ").append(quotedComment);
        }
    }

    private void addDefaultTTL(WithAdder with) {
        if (this.defaultTTL != null) {
            with.add().append(" default_time_to_live = ").append(this.defaultTTL);
        }
    }

    private String maybeQualify(String elementName) {
        if (this.keyspaceName == null) {
            return QueryBuilderImpl.cqlName(elementName);
        }
        return QueryBuilderImpl.cqlName(this.keyspaceName) + '.' + QueryBuilderImpl.cqlName(elementName);
    }

    private String createTable() {
        StringBuilder query = new StringBuilder("CREATE TABLE ");
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        }
        query.append(this.maybeQualify(this.tableName)).append(" (").append(this.createColumns.stream().map(c -> c.cqlName() + " " + CqlStrings.doubleQuoteUdts(c.type()) + (c.kind() == Column.Kind.STATIC ? " STATIC" : "")).collect(Collectors.joining(", "))).append(", ");
        this.addPrimaryKey(query, this.createColumns, this.tableName);
        query.append(")");
        WithAdder with = new WithAdder(query);
        this.addClusteringOrder(with, this.createColumns);
        this.addComment(with);
        this.addDefaultTTL(with);
        return query.toString();
    }

    private String alterTable() {
        StringBuilder query = new StringBuilder("ALTER TABLE ").append(this.maybeQualify(this.tableName));
        if (!this.addColumns.isEmpty()) {
            query.append(this.addColumns.stream().map(c -> c.cqlName() + " " + CqlStrings.doubleQuoteUdts(c.type()) + (c.kind() == Column.Kind.STATIC ? " STATIC" : "")).collect(Collectors.joining(", ", " ADD (", ")")));
        }
        if (!this.dropColumns.isEmpty()) {
            query.append(this.dropColumns.stream().map(QueryBuilderImpl::cqlName).collect(Collectors.joining(", ", " DROP (", ")")));
        }
        if (!this.columnRenames.isEmpty()) {
            query.append(this.columnRenames.entrySet().stream().map(rename -> QueryBuilderImpl.cqlName((String)rename.getKey()) + " TO " + QueryBuilderImpl.cqlName((String)rename.getValue())).collect(Collectors.joining(" AND ", " RENAME ", "")));
        }
        WithAdder with = new WithAdder(query);
        this.addComment(with);
        this.addDefaultTTL(with);
        return query.toString();
    }

    private String dropTable() {
        StringBuilder query = new StringBuilder("DROP TABLE ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        }
        query.append(this.maybeQualify(this.tableName));
        return query.toString();
    }

    private String truncateTable() {
        return "TRUNCATE " + this.maybeQualify(this.tableName);
    }

    private String createIndex() {
        StringBuilder query = new StringBuilder("CREATE");
        if (this.customIndexClass != null) {
            query.append(" CUSTOM");
        }
        query.append(" INDEX");
        if (this.ifNotExists) {
            query.append(" IF NOT EXISTS");
        }
        if (this.indexName != null) {
            query.append(" ").append(QueryBuilderImpl.cqlName(this.indexName));
        }
        query.append(" ON ").append(this.maybeQualify(this.tableName)).append(" (");
        if (this.indexingType == null) {
            query.append(QueryBuilderImpl.cqlName(this.indexCreateColumn));
        } else {
            switch (this.indexingType) {
                case KEYS: {
                    query.append("KEYS(");
                    break;
                }
                case VALUES: {
                    query.append("VALUES(");
                    break;
                }
                case ENTRIES: {
                    query.append("ENTRIES(");
                    break;
                }
                case FULL: {
                    query.append("FULL(");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled indexing type " + (Object)((Object)this.indexingType)));
                }
            }
            query.append(QueryBuilderImpl.cqlName(this.indexCreateColumn)).append(")");
        }
        query.append(")");
        if (this.customIndexClass != null) {
            query.append(" USING").append(String.format(" '%s'", this.customIndexClass));
            if (this.customIndexOptions != null && !this.customIndexOptions.isEmpty()) {
                query.append(this.customIndexOptions.entrySet().stream().map(e -> String.format("'%s': '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", ", " WITH OPTIONS = { ", " }")));
            }
        }
        return query.toString();
    }

    private String dropIndex() {
        StringBuilder query = new StringBuilder("DROP INDEX ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        }
        query.append(this.maybeQualify(this.indexName));
        return query.toString();
    }

    private String createMaterializedView() {
        StringBuilder query = new StringBuilder("CREATE MATERIALIZED VIEW ");
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        }
        query.append(this.maybeQualify(this.indexName)).append(" AS SELECT ").append(this.createColumns.stream().map(Column::cqlName).collect(Collectors.joining(", "))).append(" FROM ").append(this.maybeQualify(this.tableName)).append(" WHERE ").append(this.createColumns.stream().map(c -> c.cqlName() + " IS NOT NULL").collect(Collectors.joining(" AND "))).append(" ");
        this.addPrimaryKey(query, this.createColumns, this.indexName);
        WithAdder with = new WithAdder(query);
        this.addClusteringOrder(with, this.createColumns);
        this.addComment(with);
        this.addDefaultTTL(with);
        return query.toString();
    }

    private String dropMaterializedView() {
        StringBuilder query = new StringBuilder("DROP MATERIALIZED VIEW ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        }
        query.append(this.maybeQualify(this.indexName));
        return query.toString();
    }

    private String createType() {
        StringBuilder query = new StringBuilder("CREATE TYPE ");
        if (this.ifNotExists) {
            query.append("IF NOT EXISTS ");
        }
        query.append(this.maybeQualify(this.typeName)).append(this.createColumns.stream().map(c -> c.cqlName() + " " + CqlStrings.doubleQuoteUdts(c.type())).collect(Collectors.joining(", ", " (", ")")));
        return query.toString();
    }

    private String renameTypeColumns() {
        return "ALTER TYPE " + this.maybeQualify(this.typeName) + " RENAME " + this.columnRenames.entrySet().stream().map(e -> (String)e.getKey() + " TO " + (String)e.getValue()).collect(Collectors.joining(" AND "));
    }

    private String dropType() {
        StringBuilder query = new StringBuilder("DROP TYPE ");
        if (this.ifExists) {
            query.append("IF EXISTS ");
        }
        query.append(this.maybeQualify(this.typeName));
        return query.toString();
    }

    private String alterType() {
        assert (!this.addColumns.isEmpty());
        return "ALTER TYPE " + this.maybeQualify(this.typeName) + " ADD " + this.addColumns.stream().map(c -> c.cqlName() + " " + CqlStrings.doubleQuoteUdts(c.type())).collect(Collectors.joining(", "));
    }

    private String insertQuery() {
        StringBuilder query = new StringBuilder("INSERT INTO ").append(this.maybeQualify(this.tableName)).append(" (").append(this.dmlModifications.stream().map(m3 -> QueryBuilderImpl.cqlName(m3.target().columnName())).collect(Collectors.joining(", "))).append(") VALUES (").append(this.dmlModifications.stream().map(m3 -> this.formatValue(m3.value())).collect(Collectors.joining(", "))).append(")");
        if (this.ifNotExists) {
            query.append(" IF NOT EXISTS");
        }
        this.addUsingClause(query);
        return query.toString();
    }

    private String formatValue(Term value) {
        return QueryBuilderImpl.formatValue(value, this.markers, this.boundValues);
    }

    static String formatValue(Term value, Map<Marker, QueryOuterClass.Value> markers, List<QueryOuterClass.Value> boundValues) {
        if (value instanceof Marker) {
            Marker marker = (Marker)value;
            QueryOuterClass.Value boundValue = markers.get(marker);
            assert (boundValue != null);
            boundValues.add(boundValue);
            return marker.asCql();
        }
        if (value instanceof Literal) {
            Object v = ((Literal)value).get();
            if (v instanceof QueryOuterClass.Value) {
                throw new IllegalStateException("gRPC value should have been converted to a marker");
            }
            if (v instanceof CharSequence) {
                return CqlStrings.quote(v.toString());
            }
            return v.toString();
        }
        if (value == null) {
            throw new AssertionError((Object)"Unexpected null value");
        }
        throw new AssertionError((Object)("Unexpected value type " + value.getClass().getName()));
    }

    private void addUsingClause(StringBuilder builder) {
        String prefix = " USING ";
        if (this.ttl != null) {
            builder.append(prefix).append("TTL ").append(this.formatValue(this.ttl));
            prefix = " AND ";
        }
        if (this.timestamp != null) {
            builder.append(prefix).append("TIMESTAMP ").append(this.formatValue(this.timestamp));
        }
    }

    private String formatModifier(ValueModifier modifier) {
        StringBuilder builder = new StringBuilder();
        String columnName = modifier.target().columnName();
        String fieldName = modifier.target().fieldName();
        Term mapKey = modifier.target().mapKey();
        String targetString = fieldName != null ? QueryBuilderImpl.cqlName(columnName) + '.' + QueryBuilderImpl.cqlName(fieldName) : (mapKey != null ? QueryBuilderImpl.cqlName(columnName) + '[' + this.formatValue(mapKey) + ']' : QueryBuilderImpl.cqlName(columnName));
        builder.append(targetString).append(" ").append(this.operationStr(modifier.operation())).append(" ").append(this.formatValue(modifier.value()));
        if (modifier.operation() == ValueModifier.Operation.PREPEND) {
            builder.append(" + ").append(targetString);
        }
        return builder.toString();
    }

    private String operationStr(ValueModifier.Operation operation) {
        switch (operation) {
            case PREPEND: 
            case SET: {
                return "=";
            }
            case APPEND: 
            case INCREMENT: {
                return "+=";
            }
            case REMOVE: {
                return "-=";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String updateQuery() {
        StringBuilder builder = new StringBuilder("UPDATE ").append(this.maybeQualify(this.tableName));
        this.addUsingClause(builder);
        builder.append(" SET ").append(this.dmlModifications.stream().map(this::formatModifier).collect(Collectors.joining(", ")));
        this.appendWheres(builder);
        this.appendIfs(builder);
        return builder.toString();
    }

    private void appendWheres(StringBuilder builder) {
        this.appendConditions(this.wheres, " WHERE ", builder);
    }

    private void appendIfs(StringBuilder builder) {
        this.appendConditions(this.ifs, " IF ", builder);
    }

    private void appendConditions(List<BuiltCondition> conditions, String initialPrefix, StringBuilder builder) {
        String prefix = initialPrefix;
        if (initialPrefix.contains("IF") && this.ifExists) {
            builder.append(prefix).append("EXISTS");
            prefix = " AND ";
        }
        for (BuiltCondition condition : conditions) {
            builder.append(prefix);
            condition.lhs().appendToBuilder(builder, this.markers, this.boundValues);
            builder.append(" ").append(condition.predicate().toString()).append(" ").append(this.formatValue(condition.value()));
            prefix = " AND ";
        }
    }

    private String deleteQuery() {
        StringBuilder builder = new StringBuilder("DELETE");
        if (!this.selection.isEmpty()) {
            builder.append(this.selection.stream().map(QueryBuilderImpl::cqlName).collect(Collectors.joining(", ", " ", "")));
        }
        builder.append(" FROM ").append(this.maybeQualify(this.tableName));
        this.addUsingClause(builder);
        this.appendWheres(builder);
        this.appendIfs(builder);
        return builder.toString();
    }

    protected String selectQuery() {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (this.selection.isEmpty() && this.functionCalls.isEmpty()) {
            builder.append('*');
        } else {
            builder.append(Stream.concat(this.selection.stream().map(QueryBuilderImpl::cqlName), this.functionCalls.stream().map(QueryBuilderImpl::formatFunctionCall)).collect(Collectors.joining(", ")));
        }
        builder.append(" FROM ").append(this.maybeQualify(this.tableName));
        this.appendWheres(builder);
        if (!this.groupBys.isEmpty()) {
            builder.append(" GROUP BY ").append(this.groupBys.stream().map(QueryBuilderImpl::cqlName).collect(Collectors.joining(", ")));
        }
        if (!this.orders.isEmpty()) {
            builder.append(" ORDER BY ").append(this.orders.entrySet().stream().map(e -> QueryBuilderImpl.cqlName((String)e.getKey()) + " " + ((Column.Order)((Object)((Object)e.getValue()))).name()).collect(Collectors.joining(", ")));
        }
        if (this.perPartitionLimit != null) {
            builder.append(" PER PARTITION LIMIT ").append(this.formatValue(this.perPartitionLimit));
        }
        if (this.limit != null) {
            builder.append(" LIMIT ").append(this.formatValue(this.limit));
        }
        if (this.allowFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        return builder.toString();
    }

    private Term termFor(Object value) {
        if (value instanceof Marker) {
            throw new IllegalArgumentException("Using Marker instances as values is not supported. Pass a QueryOuterClass.Value instead, and it will be converted to a marker internally. ");
        }
        if (value == null || value instanceof QueryOuterClass.Value) {
            Marker marker = new Marker();
            QueryOuterClass.Value grpcValue = value == null ? Values.NULL : (QueryOuterClass.Value)value;
            this.markers.put(marker, grpcValue);
            return marker;
        }
        return Term.of(value);
    }

    private Term bindGrpcValues(Term t) {
        if (!(t instanceof Literal)) {
            return t;
        }
        Object o = ((Literal)t).get();
        if (!(o instanceof QueryOuterClass.Value)) {
            return t;
        }
        return this.termFor(o);
    }

    private ValueModifier.Target bindGrpcValues(ValueModifier.Target t) {
        Term mapKey = t.mapKey();
        if (mapKey == null) {
            return t;
        }
        if (!(mapKey instanceof Literal)) {
            return t;
        }
        Object o = ((Literal)mapKey).get();
        if (!(o instanceof QueryOuterClass.Value)) {
            return t;
        }
        return ValueModifier.Target.mapValue(t.columnName(), this.termFor(o));
    }

    private BuiltCondition.LHS bindGrpcValues(BuiltCondition.LHS lhs) {
        return lhs.value().filter(v -> v instanceof Literal).map(v -> {
            Term newValue = this.termFor(((Literal)v).get());
            return new BuiltCondition.LHS.MapElement(lhs.columnName(), newValue);
        }).orElse(lhs);
    }

    private BuiltCondition bindGrpcValues(BuiltCondition where) {
        BuiltCondition.LHS newLhs = this.bindGrpcValues(where.lhs());
        Term newValue = this.bindGrpcValues(where.value());
        if (newValue != where.value() || newLhs != where.lhs()) {
            where = BuiltCondition.of(newLhs, where.predicate(), newValue);
        }
        return where;
    }

    private static String formatFunctionCall(FunctionCall functionCall) {
        StringBuilder builder = new StringBuilder();
        builder.append(functionCall.getFunctionName()).append('(').append(QueryBuilderImpl.cqlName(functionCall.getColumnName())).append(')');
        if (functionCall.getAlias() != null) {
            builder.append(" AS ").append(QueryBuilderImpl.cqlName(functionCall.getAlias()));
        }
        return builder.toString();
    }

    public static class FunctionCall {
        final String columnName;
        String alias;
        final String functionName;

        private FunctionCall(String columnName, String alias, String functionName) {
            this.columnName = columnName;
            this.alias = alias;
            this.functionName = functionName;
        }

        public static FunctionCall function(String name, String alias, String functionName) {
            return new FunctionCall(name, alias, functionName);
        }

        public static FunctionCall count(String columnName) {
            return FunctionCall.count(columnName, null);
        }

        public static FunctionCall count(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "COUNT");
        }

        public static FunctionCall max(String columnName) {
            return FunctionCall.max(columnName, null);
        }

        public static FunctionCall max(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "MAX");
        }

        public static FunctionCall min(String columnName) {
            return FunctionCall.min(columnName, null);
        }

        public static FunctionCall min(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "MIN");
        }

        public static FunctionCall avg(String columnName) {
            return FunctionCall.avg(columnName, null);
        }

        public static FunctionCall avg(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "AVG");
        }

        public static FunctionCall sum(String columnName) {
            return FunctionCall.sum(columnName, null);
        }

        public static FunctionCall sum(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "SUM");
        }

        public static FunctionCall writeTime(String columnName) {
            return FunctionCall.writeTime(columnName, null);
        }

        public static FunctionCall writeTime(String columnName, String alias) {
            return FunctionCall.function(columnName, alias, "WRITETIME");
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    private static class WithAdder {
        private final StringBuilder builder;
        private boolean withAdded;

        private WithAdder(StringBuilder builder) {
            this.builder = builder;
        }

        private StringBuilder add() {
            if (!this.withAdded) {
                this.builder.append(" WITH");
                this.withAdded = true;
            } else {
                this.builder.append(" AND");
            }
            return this.builder;
        }
    }
}

