/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.tags;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jersey2.server.JerseyTags;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class HttpMeterTagsProvider
implements JerseyTagsProvider {
    private final HttpMetricsTagProvider httpMetricsTagProvider;

    public HttpMeterTagsProvider() {
        this(null);
    }

    public HttpMeterTagsProvider(HttpMetricsTagProvider httpMetricsTagProvider) {
        this.httpMetricsTagProvider = httpMetricsTagProvider;
    }

    @Override
    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        ContainerResponse response = event.getContainerResponse();
        ContainerRequest request = event.getContainerRequest();
        Tags result = Tags.of(JerseyTags.method(request), JerseyTags.uri(event), JerseyTags.status(response));
        if (null != this.httpMetricsTagProvider) {
            return result.and(this.httpMetricsTagProvider.getRequestTags(event.getContainerRequest().getHeaders()));
        }
        return result;
    }

    @Override
    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        ContainerRequest request = event.getContainerRequest();
        Tags result = Tags.of(JerseyTags.method(request), JerseyTags.uri(event));
        if (null != this.httpMetricsTagProvider) {
            return result.and(this.httpMetricsTagProvider.getRequestTags(event.getContainerRequest().getHeaders()));
        }
        return result;
    }
}

