/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.core.metrics.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class PrefixingMetricRegistry
extends MetricRegistry {
    private final MetricRegistry backingRegistry;
    private final String prefix;
    private final String prefixDot;
    private final MetricFilter isPrefixedFilter;

    public PrefixingMetricRegistry(MetricRegistry backingRegistry, String prefix) {
        this.backingRegistry = backingRegistry;
        this.prefix = prefix;
        this.prefixDot = prefix + ".";
        this.isPrefixedFilter = (name, metric) -> this.isPrefixed(name);
    }

    @Override
    protected ConcurrentMap<String, Metric> buildMap() {
        return null;
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.backingRegistry.register(this.addPrefix(name), metric);
    }

    @Override
    public void registerAll(MetricSet metrics) throws IllegalArgumentException {
        this.backingRegistry.registerAll(this.prefix, metrics);
    }

    @Override
    public void registerAll(String prefix, MetricSet metrics) throws IllegalArgumentException {
        this.backingRegistry.registerAll(this.addPrefix(prefix), metrics);
    }

    @Override
    public Counter counter(String name) {
        return this.backingRegistry.counter(this.addPrefix(name));
    }

    @Override
    public Counter counter(String name, MetricRegistry.MetricSupplier<Counter> supplier) {
        return this.backingRegistry.counter(this.addPrefix(name), supplier);
    }

    @Override
    public Histogram histogram(String name) {
        return this.backingRegistry.histogram(this.addPrefix(name));
    }

    @Override
    public Histogram histogram(String name, MetricRegistry.MetricSupplier<Histogram> supplier) {
        return this.backingRegistry.histogram(this.addPrefix(name), supplier);
    }

    @Override
    public Meter meter(String name) {
        return this.backingRegistry.meter(this.addPrefix(name));
    }

    @Override
    public Meter meter(String name, MetricRegistry.MetricSupplier<Meter> supplier) {
        return this.backingRegistry.meter(this.addPrefix(name), supplier);
    }

    @Override
    public Timer timer(String name) {
        return this.backingRegistry.timer(this.addPrefix(name));
    }

    @Override
    public Timer timer(String name, MetricRegistry.MetricSupplier<Timer> supplier) {
        return this.backingRegistry.timer(this.addPrefix(name), supplier);
    }

    @Override
    public Gauge gauge(String name, MetricRegistry.MetricSupplier<Gauge> supplier) {
        return this.backingRegistry.gauge(this.addPrefix(name), supplier);
    }

    @Override
    public boolean remove(String name) {
        return this.backingRegistry.remove(this.addPrefix(name));
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        this.backingRegistry.removeMatching(new PrefixingFilter(filter));
    }

    @Override
    public void addListener(MetricRegistryListener listener) {
        this.backingRegistry.addListener(new PrefixingListener(listener));
    }

    @Override
    public void removeListener(MetricRegistryListener listener) {
        this.backingRegistry.removeListener(new PrefixingListener(listener));
    }

    @Override
    public SortedSet<String> getNames() {
        return this.stripPrefix(this.backingRegistry.getNames());
    }

    @Override
    public SortedMap<String, Gauge> getGauges() {
        return this.stripPrefix(this.backingRegistry.getGauges(this.isPrefixedFilter));
    }

    @Override
    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.stripPrefix(this.backingRegistry.getGauges(new PrefixingFilter(filter)));
    }

    @Override
    public SortedMap<String, Counter> getCounters() {
        return this.stripPrefix(this.backingRegistry.getCounters(this.isPrefixedFilter));
    }

    @Override
    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.stripPrefix(this.backingRegistry.getCounters(new PrefixingFilter(filter)));
    }

    @Override
    public SortedMap<String, Histogram> getHistograms() {
        return this.stripPrefix(this.backingRegistry.getHistograms(this.isPrefixedFilter));
    }

    @Override
    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.stripPrefix(this.backingRegistry.getHistograms(new PrefixingFilter(filter)));
    }

    @Override
    public SortedMap<String, Meter> getMeters() {
        return this.stripPrefix(this.backingRegistry.getMeters(this.isPrefixedFilter));
    }

    @Override
    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.stripPrefix(this.backingRegistry.getMeters(new PrefixingFilter(filter)));
    }

    @Override
    public SortedMap<String, Timer> getTimers() {
        return this.stripPrefix(this.backingRegistry.getTimers(this.isPrefixedFilter));
    }

    @Override
    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.stripPrefix(this.backingRegistry.getTimers(new PrefixingFilter(filter)));
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.stripPrefix(this.backingRegistry.getMetrics());
    }

    private String addPrefix(String name) {
        return MetricRegistry.name(this.prefix, name);
    }

    private boolean isPrefixed(String name) {
        return name.startsWith(this.prefixDot);
    }

    private String stripPrefix(String name) {
        assert (this.isPrefixed(name));
        return name.substring(this.prefixDot.length());
    }

    private SortedSet<String> stripPrefix(SortedSet<String> in) {
        TreeSet<String> out = new TreeSet<String>();
        for (String name : in) {
            if (!this.isPrefixed(name)) continue;
            out.add(this.stripPrefix(name));
        }
        return Collections.unmodifiableSortedSet(out);
    }

    private <MetricT extends Metric> SortedMap<String, MetricT> stripPrefix(Map<String, MetricT> in) {
        TreeMap<String, Metric> out = new TreeMap<String, Metric>();
        for (Map.Entry<String, MetricT> entry : in.entrySet()) {
            String name = entry.getKey();
            if (!this.isPrefixed(name)) continue;
            out.put(this.stripPrefix(name), (Metric)entry.getValue());
        }
        return Collections.unmodifiableSortedMap(out);
    }

    private class PrefixingListener
    implements MetricRegistryListener {
        private final MetricRegistryListener listener;

        public PrefixingListener(MetricRegistryListener listener) {
            this.listener = listener;
        }

        @Override
        public void onGaugeAdded(String name, Gauge<?> gauge) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onGaugeAdded(PrefixingMetricRegistry.this.stripPrefix(name), gauge);
            }
        }

        @Override
        public void onGaugeRemoved(String name) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onGaugeRemoved(PrefixingMetricRegistry.this.stripPrefix(name));
            }
        }

        @Override
        public void onCounterAdded(String name, Counter counter) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onCounterAdded(PrefixingMetricRegistry.this.stripPrefix(name), counter);
            }
        }

        @Override
        public void onCounterRemoved(String name) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onCounterRemoved(PrefixingMetricRegistry.this.stripPrefix(name));
            }
        }

        @Override
        public void onHistogramAdded(String name, Histogram histogram) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onHistogramAdded(PrefixingMetricRegistry.this.stripPrefix(name), histogram);
            }
        }

        @Override
        public void onHistogramRemoved(String name) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onHistogramRemoved(PrefixingMetricRegistry.this.stripPrefix(name));
            }
        }

        @Override
        public void onMeterAdded(String name, Meter meter) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onMeterAdded(PrefixingMetricRegistry.this.stripPrefix(name), meter);
            }
        }

        @Override
        public void onMeterRemoved(String name) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onMeterRemoved(PrefixingMetricRegistry.this.stripPrefix(name));
            }
        }

        @Override
        public void onTimerAdded(String name, Timer timer) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onTimerAdded(PrefixingMetricRegistry.this.stripPrefix(name), timer);
            }
        }

        @Override
        public void onTimerRemoved(String name) {
            if (PrefixingMetricRegistry.this.isPrefixed(name)) {
                this.listener.onTimerRemoved(PrefixingMetricRegistry.this.stripPrefix(name));
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof PrefixingListener) {
                PrefixingListener that = (PrefixingListener)other;
                return Objects.equals(this.listener, that.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    private class PrefixingFilter
    implements MetricFilter {
        private final MetricFilter filter;

        public PrefixingFilter(MetricFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(String name, Metric metric) {
            return PrefixingMetricRegistry.this.isPrefixed(name) && this.filter.matches(PrefixingMetricRegistry.this.stripPrefix(name), metric);
        }
    }
}

