/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.DataSize;
import io.dropwizard.util.DataSizeUnit;
import io.dropwizard.validation.MaxDataSize;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MaxDataSizeValidator
implements ConstraintValidator<MaxDataSize, DataSize> {
    private long maxQty = 0L;
    private DataSizeUnit maxUnit = DataSizeUnit.BYTES;

    @Override
    public void initialize(MaxDataSize constraintAnnotation) {
        this.maxQty = constraintAnnotation.value();
        this.maxUnit = constraintAnnotation.unit();
    }

    @Override
    public boolean isValid(DataSize value, ConstraintValidatorContext context) {
        return value == null || value.toBytes() <= this.maxUnit.toBytes(this.maxQty);
    }
}

