/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.Assert;
import graphql.PublicApi;
import graphql.TrivialDataFetcher;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.InvalidCursorException;
import graphql.relay.InvalidPageSizeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

@PublicApi
public class SimpleListConnection<T>
implements DataFetcher<Connection<T>>,
TrivialDataFetcher<Connection<T>> {
    static final String DUMMY_CURSOR_PREFIX = "simple-cursor";
    private final String prefix;
    private final List<T> data;

    public SimpleListConnection(List<T> data, String prefix) {
        this.data = Assert.assertNotNull(data, () -> " data cannot be null");
        Assert.assertTrue(prefix != null && !prefix.isEmpty(), () -> "prefix cannot be null or empty");
        this.prefix = prefix;
    }

    public SimpleListConnection(List<T> data) {
        this(data, DUMMY_CURSOR_PREFIX);
    }

    private List<Edge<T>> buildEdges() {
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>();
        int ix = 0;
        for (T object : this.data) {
            edges.add(new DefaultEdge<T>(object, new DefaultConnectionCursor(this.createCursor(ix++))));
        }
        return edges;
    }

    @Override
    public Connection<T> get(DataFetchingEnvironment environment) {
        int beforeOffset;
        int end;
        List<Edge<T>> edges = this.buildEdges();
        if (edges.size() == 0) {
            return this.emptyConnection();
        }
        ConnectionCursor firstPresliceCursor = edges.get(0).getCursor();
        ConnectionCursor lastPresliceCursor = edges.get(edges.size() - 1).getCursor();
        int afterOffset = this.getOffsetFromCursor((String)environment.getArgument("after"), -1);
        int begin = Math.max(afterOffset, -1) + 1;
        if (begin > (end = Math.min(beforeOffset = this.getOffsetFromCursor((String)environment.getArgument("before"), edges.size()), edges.size()))) {
            begin = end;
        }
        if ((edges = edges.subList(begin, end)).size() == 0) {
            return this.emptyConnection();
        }
        Integer first = (Integer)environment.getArgument("first");
        Integer last = (Integer)environment.getArgument("last");
        if (first != null) {
            if (first < 0) {
                throw new InvalidPageSizeException(String.format("The page size must not be negative: 'first'=%s", first));
            }
            edges = edges.subList(0, first <= edges.size() ? first.intValue() : edges.size());
        }
        if (last != null) {
            if (last < 0) {
                throw new InvalidPageSizeException(String.format("The page size must not be negative: 'last'=%s", last));
            }
            edges = edges.subList(last > edges.size() ? 0 : edges.size() - last, edges.size());
        }
        if (edges.isEmpty()) {
            return this.emptyConnection();
        }
        Edge<T> firstEdge = edges.get(0);
        Edge<T> lastEdge = edges.get(edges.size() - 1);
        DefaultPageInfo pageInfo = new DefaultPageInfo(firstEdge.getCursor(), lastEdge.getCursor(), !firstEdge.getCursor().equals(firstPresliceCursor), !lastEdge.getCursor().equals(lastPresliceCursor));
        return new DefaultConnection<T>(edges, pageInfo);
    }

    private Connection<T> emptyConnection() {
        DefaultPageInfo pageInfo = new DefaultPageInfo(null, null, false, false);
        return new DefaultConnection(Collections.emptyList(), pageInfo);
    }

    public ConnectionCursor cursorForObjectInConnection(T object) {
        int index = this.data.indexOf(object);
        if (index == -1) {
            return null;
        }
        String cursor = this.createCursor(index);
        return new DefaultConnectionCursor(cursor);
    }

    private int getOffsetFromCursor(String cursor, int defaultValue) {
        byte[] decode;
        if (cursor == null) {
            return defaultValue;
        }
        try {
            decode = Base64.getDecoder().decode(cursor);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidCursorException(String.format("The cursor is not in base64 format : '%s'", cursor), e);
        }
        String string = new String(decode, StandardCharsets.UTF_8);
        if (this.prefix.length() > string.length()) {
            throw new InvalidCursorException(String.format("The cursor prefix is missing from the cursor : '%s'", cursor));
        }
        try {
            return Integer.parseInt(string.substring(this.prefix.length()));
        }
        catch (NumberFormatException nfe) {
            throw new InvalidCursorException(String.format("The cursor was not created by this class  : '%s'", cursor), nfe);
        }
    }

    private String createCursor(int offset) {
        byte[] bytes = (this.prefix + Integer.toString(offset)).getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(bytes);
    }
}

