/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.types.TypeConverter;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ParseState<T> {
    private final List<Context> locationStack;
    private final GlobalMetadata<T> global;
    private final ParserMetadata<T> parserConfig;
    private final CommandGroupMetadata group;
    private final CommandMetadata command;
    private final List<Pair<OptionMetadata, Object>> parsedOptions;
    private final Map<OptionMetadata, Integer> optionsCount;
    private final List<Object> parsedArguments;
    private final OptionMetadata currentOption;
    private final List<String> unparsedInput;

    ParseState(GlobalMetadata<T> global, ParserMetadata<T> parserConfig, CommandGroupMetadata group, CommandMetadata command, List<Pair<OptionMetadata, Object>> parsedOptions, Map<OptionMetadata, Integer> optionsCount, List<Context> locationStack, List<Object> parsedArguments, OptionMetadata currentOption, List<String> unparsedInput) {
        this.global = global;
        this.parserConfig = global != null ? global.getParserConfiguration() : (parserConfig != null ? parserConfig : ParserBuilder.defaultConfiguration());
        this.group = group;
        this.command = command;
        this.parsedOptions = parsedOptions;
        this.optionsCount = optionsCount;
        this.locationStack = locationStack;
        this.parsedArguments = parsedArguments;
        this.currentOption = currentOption;
        this.unparsedInput = unparsedInput;
    }

    public static <T> ParseState<T> newInstance() {
        return new ParseState<T>(null, null, null, null, new ArrayList<Pair<OptionMetadata, Object>>(), new HashMap<OptionMetadata, Integer>(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList());
    }

    public ParseState<T> pushContext(Context location) {
        List<Context> locations = AirlineUtils.listCopy(this.locationStack);
        locations.add(location);
        return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, locations, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState<T> popContext() {
        List<Context> locationStack = AirlineUtils.unmodifiableListCopy(this.locationStack.subList(0, this.locationStack.size() - 1));
        return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState<T> withOptionValue(OptionMetadata option, String rawValue) {
        for (OptionRestriction restriction : option.getRestrictions()) {
            try {
                restriction.preValidate(this, option, rawValue);
            }
            catch (ParseException e) {
                this.parserConfig.getErrorHandler().handleError(e);
            }
        }
        try {
            Integer index = this.optionsCount.get(option);
            if (index == null) {
                index = 0;
            }
            TypeConverter converter = option.getTypeConverterProvider().getTypeConverter(option, this);
            Object value = converter.convert(option.getTitle(option.getArity() > 0 ? index % option.getArity() : 0), option.getJavaType(), rawValue);
            for (OptionRestriction restriction : option.getRestrictions()) {
                try {
                    restriction.postValidate(this, option, value);
                }
                catch (ParseException e) {
                    this.parserConfig.getErrorHandler().handleError(e);
                }
            }
            List<Pair<OptionMetadata, Object>> newOptions = AirlineUtils.listCopy(this.parsedOptions);
            newOptions.add(Pair.of(option, value));
            HashMap<OptionMetadata, Integer> newOptionsCount = new HashMap<OptionMetadata, Integer>(this.optionsCount);
            index = index + 1;
            newOptionsCount.put(option, index);
            return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, newOptions, newOptionsCount, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
        }
        catch (ParseException e) {
            this.parserConfig.getErrorHandler().handleError(e);
            List<String> newUnparsed = AirlineUtils.listCopy(this.unparsedInput);
            newUnparsed.add(rawValue);
            return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, newUnparsed);
        }
    }

    public ParseState<T> withGlobal(GlobalMetadata<T> global) {
        return new ParseState<T>(global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState<T> withConfiguration(ParserMetadata<T> parserConfig) {
        return new ParseState<T>(this.global, parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState<T> withGroup(CommandGroupMetadata group) {
        return new ParseState<T>(this.global, this.parserConfig, group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState<T> withCommand(CommandMetadata command) {
        return new ParseState<T>(this.global, this.parserConfig, this.group, command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, this.unparsedInput);
    }

    public ParseState<T> withOption(OptionMetadata option) {
        return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, option, this.unparsedInput);
    }

    public ParseState<T> withArgument(ArgumentsMetadata arguments, String rawValue) {
        for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
            try {
                restriction.preValidate(this, arguments, rawValue);
            }
            catch (ParseException e) {
                this.parserConfig.getErrorHandler().handleError(e);
            }
        }
        try {
            TypeConverter converter = arguments.getTypeConverterProvider().getTypeConverter(arguments, this);
            Object value = converter.convert(arguments.getTitle().get(0), arguments.getJavaType(), rawValue);
            for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                try {
                    restriction.postValidate(this, arguments, value);
                }
                catch (ParseException e) {
                    this.parserConfig.getErrorHandler().handleError(e);
                }
            }
            List<Object> newArguments = AirlineUtils.listCopy(this.parsedArguments);
            newArguments.add(value);
            return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, newArguments, this.currentOption, this.unparsedInput);
        }
        catch (ParseException e) {
            this.parserConfig.getErrorHandler().handleError(e);
            List<String> newUnparsed = AirlineUtils.listCopy(this.unparsedInput);
            newUnparsed.add(rawValue);
            return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, newUnparsed);
        }
    }

    public ParseState<T> withUnparsedInput(String input) {
        List<String> newUnparsedInput = AirlineUtils.listCopy(this.unparsedInput);
        newUnparsedInput.add(input);
        return new ParseState<T>(this.global, this.parserConfig, this.group, this.command, this.parsedOptions, this.optionsCount, this.locationStack, this.parsedArguments, this.currentOption, newUnparsedInput);
    }

    public String toString() {
        return "ParseState{locationStack=" + this.locationStack + ", global=" + this.global + ", group=" + this.group + ", command=" + this.command + ", parsedOptions=" + this.parsedOptions + ", optionsCount=" + this.optionsCount + ", parsedArguments=" + this.parsedArguments + ", currentOption=" + this.currentOption + ", unparsedInput=" + this.unparsedInput + '}';
    }

    public Context getLocation() {
        return this.locationStack.get(this.locationStack.size() - 1);
    }

    public GlobalMetadata<T> getGlobal() {
        return this.global;
    }

    public ParserMetadata<T> getParserConfiguration() {
        return this.global != null ? this.global.getParserConfiguration() : this.parserConfig;
    }

    public CommandGroupMetadata getGroup() {
        return this.group;
    }

    public CommandMetadata getCommand() {
        return this.command;
    }

    public OptionMetadata getCurrentOption() {
        return this.currentOption;
    }

    public List<Pair<OptionMetadata, Object>> getParsedOptions() {
        return this.parsedOptions;
    }

    public int getOptionValuesSeen(OptionMetadata option) {
        Integer count = this.optionsCount.get(option);
        return count == null ? 0 : count;
    }

    public List<Object> getParsedArguments() {
        return this.parsedArguments;
    }

    public List<String> getUnparsedInput() {
        return this.unparsedInput;
    }
}

