/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.sections.factories;

import com.github.rvesse.airline.annotations.help.Copyright;
import com.github.rvesse.airline.annotations.help.Discussion;
import com.github.rvesse.airline.annotations.help.Examples;
import com.github.rvesse.airline.annotations.help.ExitCodes;
import com.github.rvesse.airline.annotations.help.HideSection;
import com.github.rvesse.airline.annotations.help.License;
import com.github.rvesse.airline.annotations.help.ProseSection;
import com.github.rvesse.airline.annotations.help.Version;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.common.BasicSection;
import com.github.rvesse.airline.help.sections.common.DiscussionSection;
import com.github.rvesse.airline.help.sections.common.ExamplesSection;
import com.github.rvesse.airline.help.sections.common.ExitCodesSection;
import com.github.rvesse.airline.help.sections.common.VersionSection;
import com.github.rvesse.airline.help.sections.factories.HelpSectionFactory;
import com.github.rvesse.airline.parser.ParserUtil;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CommonSectionsFactory
implements HelpSectionFactory {
    @Override
    public HelpSection createSection(Annotation annotation) {
        if (annotation instanceof Examples) {
            Examples ex = (Examples)annotation;
            return new ExamplesSection(ex.examples(), ex.descriptions());
        }
        if (annotation instanceof Discussion) {
            return new DiscussionSection(((Discussion)annotation).paragraphs());
        }
        if (annotation instanceof ExitCodes) {
            ExitCodes exits = (ExitCodes)annotation;
            return new ExitCodesSection(exits.codes(), exits.descriptions());
        }
        if (annotation instanceof HideSection) {
            HideSection hide = (HideSection)annotation;
            return new BasicSection(hide.title(), 0, null, null, HelpFormat.NONE_PRINTABLE, (String[][])new String[][]{new String[0]});
        }
        if (annotation instanceof ProseSection) {
            ProseSection prose = (ProseSection)annotation;
            return new com.github.rvesse.airline.help.sections.common.ProseSection(prose.title(), prose.suggestedOrder(), prose.paragraphs());
        }
        if (annotation instanceof Copyright) {
            Copyright copyright = (Copyright)annotation;
            String line = String.format("Copyright (c) %s %s%s", copyright.holder(), copyright.startYear(), copyright.endYear() > copyright.startYear() ? String.format("-%s", copyright.endYear()) : "");
            return new com.github.rvesse.airline.help.sections.common.ProseSection("Copyright", 50, new String[]{line});
        }
        if (annotation instanceof License) {
            License license = (License)annotation;
            String[] data = Arrays.copyOf(license.paragraphs(), StringUtils.isNotBlank(license.url()) ? license.paragraphs().length + 1 : license.paragraphs().length);
            if (StringUtils.isNotBlank(license.url())) {
                data[data.length - 1] = String.format("Please see %s for more information", license.url());
            }
            return new com.github.rvesse.airline.help.sections.common.ProseSection("License", 60, data);
        }
        if (annotation instanceof Version) {
            Version version = (Version)annotation;
            ResourceLocator[] locators = ParserUtil.createResourceLocators(version.sourceLocators());
            return new VersionSection(version.sources(), locators, version.componentProperty(), version.versionProperty(), version.buildProperty(), version.dateProperty(), version.additionalProperties(), version.additionalTitles(), version.suppressOnError(), version.tabular());
        }
        return null;
    }

    @Override
    public List<Class<? extends Annotation>> supportedAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(Examples.class);
        supported.add(Discussion.class);
        supported.add(ExitCodes.class);
        supported.add(HideSection.class);
        supported.add(ProseSection.class);
        supported.add(Copyright.class);
        supported.add(License.class);
        supported.add(Version.class);
        return supported;
    }
}

