/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import com.google.common.base.MoreObjects;
import io.stargate.proto.QueryOuterClass;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.schema.CassandraFetcher;
import io.stargate.sgv2.graphql.web.resources.GraphqlCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class StargateGraphqlContext {
    private final HttpServletRequest httpRequest;
    private final StargateBridgeClient bridge;
    private final GraphqlCache graphqlCache;
    private final BatchContext batchContext = new BatchContext();
    private volatile boolean overloaded;

    public StargateGraphqlContext(HttpServletRequest httpRequest, StargateBridgeClient bridge, GraphqlCache graphqlCache) {
        this.httpRequest = httpRequest;
        this.bridge = bridge;
        this.graphqlCache = graphqlCache;
    }

    public StargateBridgeClient getBridge() {
        return this.bridge;
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public void setOverloaded() {
        this.overloaded = true;
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public static class BatchContext {
        private final List<QueryOuterClass.BatchQuery> queries = new ArrayList<QueryOuterClass.BatchQuery>();
        private int operationCount;
        private final CompletableFuture<QueryOuterClass.Response> executionFuture = new CompletableFuture();
        private final AtomicReference<QueryOuterClass.QueryParameters> parameters = new AtomicReference();

        public CompletableFuture<QueryOuterClass.Response> getExecutionFuture() {
            return this.executionFuture;
        }

        public synchronized List<QueryOuterClass.BatchQuery> getQueries() {
            return this.queries;
        }

        public void setExecutionResult(CompletionStage<QueryOuterClass.Response> response) {
            response.thenApply(this.executionFuture::complete).exceptionally(this.executionFuture::completeExceptionally);
        }

        public void setExecutionResult(Exception ex) {
            this.executionFuture.completeExceptionally(ex);
        }

        public synchronized int add(QueryOuterClass.Query query) {
            this.queries.add(this.toBatchQuery(query));
            ++this.operationCount;
            return this.operationCount;
        }

        public synchronized int add(List<QueryOuterClass.Query> newQueries) {
            newQueries.forEach(query -> this.queries.add(this.toBatchQuery((QueryOuterClass.Query)query)));
            ++this.operationCount;
            return this.operationCount;
        }

        public boolean setParameters(QueryOuterClass.QueryParameters newParameters) {
            QueryOuterClass.QueryParameters currentParameters;
            while ((currentParameters = this.parameters.get()) == null) {
                if (!this.parameters.compareAndSet(null, newParameters)) continue;
                return true;
            }
            return newParameters.equals(currentParameters);
        }

        public QueryOuterClass.BatchParameters getParameters() {
            QueryOuterClass.QueryParameters queryParameters = MoreObjects.firstNonNull(this.parameters.get(), CassandraFetcher.DEFAULT_PARAMETERS);
            return this.toBatchParameters(queryParameters);
        }

        private QueryOuterClass.BatchQuery toBatchQuery(QueryOuterClass.Query query) {
            return QueryOuterClass.BatchQuery.newBuilder().setCql(query.getCql()).setValues(query.getValues()).build();
        }

        private QueryOuterClass.BatchParameters toBatchParameters(QueryOuterClass.QueryParameters queryParameters) {
            return QueryOuterClass.BatchParameters.newBuilder().setConsistency(queryParameters.getConsistency()).setTracing(queryParameters.getTracing()).setTimestamp(queryParameters.getTimestamp()).setSerialConsistency(queryParameters.getSerialConsistency()).setNowInSeconds(queryParameters.getNowInSeconds()).setTracingConsistency(queryParameters.getTracingConsistency()).setSkipMetadata(queryParameters.getSkipMetadata()).build();
        }
    }
}

