/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import com.google.common.io.Resources;
import io.dropwizard.util.Strings;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Produces(value={"text/html"})
@Path(value="/playground")
@Singleton
public class PlaygroundResource {
    private final String playgroundFile;

    public PlaygroundResource() throws IOException {
        URL url = Resources.getResource("playground.html");
        this.playgroundFile = Resources.toString(url, StandardCharsets.UTF_8);
    }

    @GET
    public Response get(@Context HttpServletRequest request) {
        String token = request.getHeader("x-cassandra-token");
        if (Strings.isNullOrEmpty(token)) {
            token = request.getHeader("Authorization");
            token = Strings.isNullOrEmpty(token) ? token : token.replaceFirst("^Bearer\\s", "");
        }
        String formattedPlaygroundFile = this.playgroundFile.replaceFirst("AUTHENTICATION_TOKEN", token == null ? "" : token);
        return Response.ok(formattedPlaygroundFile).build();
    }
}

