/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.sgv2.common.futures.Futures;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.schema.CassandraFetcherExceptionHandler;
import io.stargate.sgv2.graphql.schema.cqlfirst.SchemaFactory;
import io.stargate.sgv2.graphql.web.resources.DefaultKeyspaceHelper;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class GraphqlCache {
    private final boolean disableDefaultKeyspace;
    private final GraphQL ddlGraphql;
    private volatile CompletionStage<Optional<String>> defaultKeyspaceName;
    private final Cache<String, GraphqlHolder> dmlGraphqlCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public GraphqlCache(boolean disableDefaultKeyspace) {
        this.disableDefaultKeyspace = disableDefaultKeyspace;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema());
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public CompletionStage<Optional<GraphQL>> getDmlAsync(StargateBridgeClient bridge, String keyspaceName) {
        String decoratedKeyspaceName = bridge.decorateKeyspaceName(keyspaceName);
        GraphqlHolder holder = this.dmlGraphqlCache.get(decoratedKeyspaceName, __ -> new GraphqlHolder(keyspaceName));
        assert (holder != null);
        return holder.getGraphql(bridge);
    }

    public Optional<GraphQL> getDml(StargateBridgeClient bridge, String keyspaceName) {
        return Futures.getUninterruptibly(this.getDmlAsync(bridge, keyspaceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Optional<String>> getDefaultKeyspaceNameAsync(StargateBridgeClient bridge) {
        CompletionStage<Optional<String>> result = this.defaultKeyspaceName;
        if (result != null) {
            return result;
        }
        GraphqlCache graphqlCache = this;
        synchronized (graphqlCache) {
            if (this.defaultKeyspaceName == null) {
                this.defaultKeyspaceName = this.disableDefaultKeyspace ? CompletableFuture.completedFuture(Optional.empty()) : new DefaultKeyspaceHelper(bridge).find();
            }
            return this.defaultKeyspaceName;
        }
    }

    public Optional<String> getDefaultKeyspaceName(StargateBridgeClient bridge) {
        return Futures.getUninterruptibly(this.getDefaultKeyspaceNameAsync(bridge));
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL(schema).defaultDataFetcherExceptionHandler(CassandraFetcherExceptionHandler.INSTANCE).mutationExecutionStrategy(new AsyncExecutionStrategy(CassandraFetcherExceptionHandler.INSTANCE)).build();
    }

    static class GraphqlHolderState {
        static GraphqlHolderState EMPTY = new GraphqlHolderState(Optional.empty(), CompletableFuture.completedFuture(Optional.empty()));
        final Optional<Integer> hash;
        final CompletableFuture<Optional<GraphQL>> graphqlFuture;

        GraphqlHolderState(Integer hash) {
            this.hash = Optional.of(hash);
            this.graphqlFuture = new CompletableFuture();
        }

        private GraphqlHolderState(Optional<Integer> hash, CompletableFuture<Optional<GraphQL>> graphqlFuture) {
            this.hash = hash;
            this.graphqlFuture = graphqlFuture;
        }
    }

    static class GraphqlHolder {
        private final String keyspaceName;
        private final AtomicReference<GraphqlHolderState> stateRef = new AtomicReference<GraphqlHolderState>(GraphqlHolderState.EMPTY);

        GraphqlHolder(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        CompletionStage<Optional<GraphQL>> getGraphql(StargateBridgeClient bridge) {
            return bridge.getKeyspaceAsync(this.keyspaceName, true).thenCompose(maybeKeyspace -> {
                GraphqlHolderState newState;
                GraphqlHolderState state;
                Optional<Integer> hash = maybeKeyspace.map(describe -> describe.getHash().getValue());
                do {
                    state = this.stateRef.get();
                    if (!state.hash.equals(hash)) continue;
                    return state.graphqlFuture;
                } while (!this.stateRef.compareAndSet(state, newState = hash.map(GraphqlHolderState::new).orElse(GraphqlHolderState.EMPTY)));
                maybeKeyspace.ifPresent(keyspace -> {
                    GraphQL graphql = GraphqlCache.newGraphql(SchemaFactory.newDmlSchema(keyspace));
                    newState.graphqlFuture.complete(Optional.of(graphql));
                });
                return newState.graphqlFuture;
            });
        }
    }
}

