/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import com.google.protobuf.BytesValue;
import io.stargate.grpc.Values;
import io.stargate.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultKeyspaceHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKeyspaceHelper.class);
    private static final QueryOuterClass.Query SELECT_KEYSPACE_NAMES = new QueryBuilder().select().column("keyspace_name").writeTimeColumn("durable_writes").from("system_schema", "keyspaces").build();
    private final StargateBridgeClient bridge;

    DefaultKeyspaceHelper(StargateBridgeClient bridge) {
        this.bridge = bridge;
    }

    CompletionStage<Optional<String>> find() {
        return this.getRows(new ArrayList<QueryOuterClass.Row>(), null).thenApply(rows -> {
            try {
                return rows.stream().filter(r -> {
                    QueryOuterClass.Value writeTime = r.getValues(1);
                    return !writeTime.hasNull() && Values.bigint(writeTime) > 0L;
                }).min(Comparator.comparing(r -> Values.bigint(r.getValues(1)))).map(r -> Values.string(r.getValues(0))).filter(ks -> !ks.equals("system") && !ks.equals("data_endpoint_auth") && !ks.equals("solr_admin") && !ks.startsWith("system_") && !ks.startsWith("dse_"));
            }
            catch (Exception e) {
                LOG.warn("Unexpected error while trying to find default keyspace", e);
                return Optional.empty();
            }
        });
    }

    private CompletionStage<List<QueryOuterClass.Row>> getRows(List<QueryOuterClass.Row> rows, BytesValue pagingState) {
        QueryOuterClass.Query query = pagingState == null ? SELECT_KEYSPACE_NAMES : QueryOuterClass.Query.newBuilder(SELECT_KEYSPACE_NAMES).setParameters(QueryOuterClass.QueryParameters.newBuilder().setPagingState(pagingState).build()).build();
        return this.bridge.executeQueryAsync(query).thenCompose(response -> {
            QueryOuterClass.ResultSet resultSet = response.getResultSet();
            rows.addAll(resultSet.getRowsList());
            return resultSet.hasPagingState() ? this.getRows(rows, resultSet.getPagingState()) : CompletableFuture.completedFuture(rows);
        });
    }
}

