/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.scalars;

import graphql.schema.CoercingParseLiteralException;
import io.stargate.sgv2.graphql.schema.scalars.TemporalCoercing;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

class TimeCoercing
extends TemporalCoercing<LocalTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS");
    static TimeCoercing INSTANCE = new TimeCoercing();

    private TimeCoercing() {
    }

    @Override
    protected String format(LocalTime value) {
        return FORMATTER.format(value);
    }

    @Override
    protected LocalTime parse(String value) {
        try {
            return LocalTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new CoercingParseLiteralException("Couldn't parse literal, expected ISO-8601 extended local time format (HH:MM:SS[s.sss])");
        }
    }

    @Override
    protected LocalTime parse(long value) {
        return LocalTime.ofNanoOfDay(value);
    }
}

