/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.scalars;

import graphql.schema.GraphQLScalarType;
import io.stargate.grpc.CqlDuration;
import io.stargate.proto.QueryOuterClass;
import io.stargate.sgv2.graphql.schema.scalars.BigIntCoercing;
import io.stargate.sgv2.graphql.schema.scalars.DateCoercing;
import io.stargate.sgv2.graphql.schema.scalars.FloatCoercing;
import io.stargate.sgv2.graphql.schema.scalars.IntCoercing;
import io.stargate.sgv2.graphql.schema.scalars.StringCoercing;
import io.stargate.sgv2.graphql.schema.scalars.TimeCoercing;
import io.stargate.sgv2.graphql.schema.scalars.TimestampCoercing;
import io.stargate.sgv2.graphql.schema.scalars.VarintCoercing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CqlScalar {
    UUID(QueryOuterClass.TypeSpec.Basic.UUID, UUID.class, GraphQLScalarType.newScalar().name("Uuid").coercing(StringCoercing.UUID).description("Represents a CQL `uuid` as a string.\nExample: \"fe86cad0-1965-11eb-84e6-ab660d2e8c9e\"").build()),
    TIMEUUID(QueryOuterClass.TypeSpec.Basic.TIMEUUID, UUID.class, GraphQLScalarType.newScalar().name("TimeUuid").coercing(StringCoercing.TIMEUUID).description("Represents a CQL `timeuuid` as a string.\nExample: \"fe86cad0-1965-11eb-84e6-ab660d2e8c9e\"").build()),
    INET(QueryOuterClass.TypeSpec.Basic.INET, InetAddress.class, GraphQLScalarType.newScalar().name("Inet").coercing(StringCoercing.INET).description("Represents a CQL `inet` as a string.\nThis is an IP address in IPv4 or IPv6 format.\nExamples: \"127.0.0.1\", \"::1\"\nIf you don't provide a numerical address, it will be resolved on the server.").build()),
    DATE(QueryOuterClass.TypeSpec.Basic.DATE, LocalDate.class, GraphQLScalarType.newScalar().name("Date").coercing(DateCoercing.INSTANCE).description("Represents a CQL `date` as a string.\nThis is a date without a time-zone in the ISO-8601 calendar system.\nExample: \"2020-10-21\".\nA date can also be input as a 32-bit, positive numeric literal, which will be interpreted as a number of days, where the epoch is in the middle of the range (1970-01-01 = 2147483648).").build()),
    DURATION(QueryOuterClass.TypeSpec.Basic.DURATION, CqlDuration.class, GraphQLScalarType.newScalar().name("Duration").coercing(StringCoercing.DURATION).description("Represents a CQL `duration` as a string.\nSee https://docs.datastax.com/en/dse/6.8/cql/cql/cql_reference/upsertDates.html\nExample: \"1h4m48s20ms\"").build()),
    BIGINT(QueryOuterClass.TypeSpec.Basic.BIGINT, Long.class, GraphQLScalarType.newScalar().name("BigInt").coercing(BigIntCoercing.INSTANCE).description("Represents a CQL `bigint` as an integer literal.\nThis is a 64-bit signed integer.").build()),
    COUNTER(QueryOuterClass.TypeSpec.Basic.COUNTER, Long.class, GraphQLScalarType.newScalar().name("Counter").coercing(BigIntCoercing.INSTANCE).description("Represents a CQL `counter` as an integer literal.\nThis is a 64-bit signed integer.").build()),
    ASCII(QueryOuterClass.TypeSpec.Basic.ASCII, String.class, GraphQLScalarType.newScalar().name("Ascii").coercing(StringCoercing.ASCII).description("Represents a CQL `ascii` as a string.\nAn error will be thrown if the string contains non-ASCII characters.").build()),
    DECIMAL(QueryOuterClass.TypeSpec.Basic.DECIMAL, BigDecimal.class, GraphQLScalarType.newScalar().name("Decimal").coercing(StringCoercing.DECIMAL).description("Represents a CQL `decimal` as a string.\nThis is a variable-precision decimal.\nExamples: \"1.5\", \"1e-3\"").build()),
    VARINT(QueryOuterClass.TypeSpec.Basic.VARINT, BigInteger.class, GraphQLScalarType.newScalar().name("Varint").coercing(VarintCoercing.INSTANCE).description("Represents a CQL `varint` as an integer.\nThis is an arbitrary-precision integer.\nExamples: 1, 9223372036854775808").build()),
    FLOAT(QueryOuterClass.TypeSpec.Basic.FLOAT, Float.class, GraphQLScalarType.newScalar().name("Float32").coercing(FloatCoercing.INSTANCE).description("Represents a CQL `float` as a floating-point literal.\nThis is a 32-bit IEEE-754 floating point.\nIf the value cannot be represented as a float, it will be converted. This conversion can loose precision, or range (resulting in +/-Infinity).").build()),
    BLOB(QueryOuterClass.TypeSpec.Basic.BLOB, ByteBuffer.class, GraphQLScalarType.newScalar().name("Blob").coercing(StringCoercing.BLOB).description("Represents a CQL `blob` as a base64 encoded string.\nExample: \"yv4=\" (for the hex value 0xCAFE)").build()),
    SMALLINT(QueryOuterClass.TypeSpec.Basic.SMALLINT, Short.class, GraphQLScalarType.newScalar().name("SmallInt").coercing(IntCoercing.SMALLINT).description("Represents a CQL `smallint` as an integer.\nThis is a 16-bit signed int.\nAn error will be thrown if the value is out of bounds.").build()),
    TINYINT(QueryOuterClass.TypeSpec.Basic.TINYINT, Byte.class, GraphQLScalarType.newScalar().name("TinyInt").coercing(IntCoercing.TINYINT).description("Represents a CQL `tinyint` as an integer\n.This is an 8-bit signed int.\nAn error will be thrown if the value is out of bounds.").build()),
    TIMESTAMP(QueryOuterClass.TypeSpec.Basic.TIMESTAMP, Instant.class, GraphQLScalarType.newScalar().name("Timestamp").coercing(TimestampCoercing.INSTANCE).description("Represents a CQL `timestamp` as a string.\nThis is an instantaneous point on the time-line.\nThis type supports many different string representations (see https://docs.datastax.com/en/cql-oss/3.x/cql/cql_reference/timestamp_type_r.html). A timestamp can also be input as a numeric literal, which will be interpreted as a number of milliseconds since the epoch (1970-01-01 UTC at midnight).\nExamples: \"2011-02-03 04:05+0000\", 1296705900000\nString literals that do not include any time zone information will be interpreted using the server's default time zone.").build()),
    TIME(QueryOuterClass.TypeSpec.Basic.TIME, LocalTime.class, GraphQLScalarType.newScalar().name("Time").coercing(TimeCoercing.INSTANCE).description("Represents a CQL `time` as a string.\nThis is a time without a time-zone in the ISO-8601 calendar system.\nExample: \"10:15:30.123456789\"\nA time can also be input as a numeric literal, which will be interpreted as a number of nanoseconds since midnight.").build());

    private static final Map<QueryOuterClass.TypeSpec.Basic, CqlScalar> FROM_CQL;
    private static final Map<String, CqlScalar> FROM_GRAPHQL_NAME;
    private final QueryOuterClass.TypeSpec.Basic cqlType;
    private final Class<?> cqlValueClass;
    private final GraphQLScalarType graphqlType;

    private CqlScalar(QueryOuterClass.TypeSpec.Basic cqlType, Class<?> cqlValueClass, GraphQLScalarType graphqlType) {
        this.cqlType = cqlType;
        this.cqlValueClass = cqlValueClass;
        this.graphqlType = graphqlType;
    }

    public QueryOuterClass.TypeSpec.Basic getCqlType() {
        return this.cqlType;
    }

    public Class<?> getCqlValueClass() {
        return this.cqlValueClass;
    }

    public GraphQLScalarType getGraphqlType() {
        return this.graphqlType;
    }

    public static Optional<CqlScalar> fromCqlType(QueryOuterClass.TypeSpec.Basic cqlType) {
        return Optional.ofNullable(FROM_CQL.get(cqlType));
    }

    public static Optional<CqlScalar> fromGraphqlName(String graphqlName) {
        return Optional.ofNullable(FROM_GRAPHQL_NAME.get(graphqlName));
    }

    static {
        FROM_CQL = Arrays.stream(CqlScalar.values()).collect(Collectors.toMap(CqlScalar::getCqlType, Function.identity()));
        FROM_GRAPHQL_NAME = Arrays.stream(CqlScalar.values()).collect(Collectors.toMap(s2 -> s2.getGraphqlType().getName(), Function.identity()));
    }
}

