/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.types;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.types.TypeBuilder;

public class MapBuilder
extends TypeBuilder {
    private final GraphQLType keyType;
    private final GraphQLType valueType;
    private final boolean isInput;

    public MapBuilder(GraphQLType keyType, GraphQLType valueType, boolean isInput) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.isInput = isInput;
    }

    public GraphQLList build() {
        return new GraphQLList(this.buildKeyValueType());
    }

    private GraphQLType buildKeyValueType() {
        String keyTypeName = this.getTypeName(this.keyType);
        String valueTypeName = this.getTypeName(this.valueType);
        String name = String.format("Entry%sKey%sValue%s", keyTypeName, valueTypeName, this.isInput ? "Input" : "");
        return this.isInput ? this.buildInputType(name) : this.buildOutputType(name);
    }

    private GraphQLInputType buildInputType(String name) {
        return GraphQLInputObjectType.newInputObject().name(name).description("Represents a key/value type for a Map").field(GraphQLInputObjectField.newInputObjectField().name("key").type(new GraphQLNonNull(this.keyType)).build()).field(GraphQLInputObjectField.newInputObjectField().name("value").type((GraphQLInputType)this.valueType).build()).build();
    }

    private GraphQLOutputType buildOutputType(String name) {
        return GraphQLObjectType.newObject().description("Represents a key/value type for a Map").name(name).field(GraphQLFieldDefinition.newFieldDefinition().name("key").type(new GraphQLNonNull(this.keyType)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type((GraphQLOutputType)this.valueType).build()).build();
    }
}

