/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.common.cql.builder.Term;
import io.stargate.sgv2.common.cql.builder.ValueModifier;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.MutationFetcher;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateMutationFetcher
extends MutationFetcher {
    public UpdateMutationFetcher(String keyspaceName, Schema.CqlTable table, NameMapping nameMapping) {
        super(keyspaceName, table, nameMapping);
    }

    @Override
    protected QueryOuterClass.Query buildQuery(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        boolean ifExists = environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && (Boolean)environment.getArgument("ifExists") != false;
        return new QueryBuilder().update(this.keyspaceName, this.table.getName()).ttl(this.getTtl(environment)).value(this.buildAssignments(environment)).where(this.buildPrimaryKeyWhere(environment)).ifs(this.buildConditions((Map)environment.getArgument("ifCondition"))).ifExists(ifExists).build();
    }

    private List<ValueModifier> buildAssignments(DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<ValueModifier> assignments = new ArrayList<ValueModifier>();
        for (Map.Entry entry : value.entrySet()) {
            QueryOuterClass.ColumnSpec column = this.dbColumnGetter.getColumn(this.table, (String)entry.getKey());
            if (this.isPrimaryKey(column)) continue;
            ValueModifier.Operation operation = column.getType().getBasic() == QueryOuterClass.TypeSpec.Basic.COUNTER ? ValueModifier.Operation.INCREMENT : ValueModifier.Operation.SET;
            assignments.add(ValueModifier.of(ValueModifier.Target.column(column.getName()), operation, Term.of(this.toGrpcValue(column.getType(), entry.getValue()))));
        }
        return assignments;
    }

    private List<BuiltCondition> buildPrimaryKeyWhere(DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        for (Map.Entry entry : value.entrySet()) {
            QueryOuterClass.ColumnSpec column = this.dbColumnGetter.getColumn(this.table, (String)entry.getKey());
            if (!this.isPrimaryKey(column)) continue;
            relations.add(BuiltCondition.of(column.getName(), Predicate.EQ, (Object)this.toGrpcValue(column.getType(), entry.getValue())));
        }
        return relations;
    }

    private boolean isPrimaryKey(QueryOuterClass.ColumnSpec column) {
        return this.table.getPartitionKeyColumnsList().contains(column) || this.table.getClusteringKeyColumnsList().contains(column);
    }
}

