/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.grpc.BytesValues;
import io.stargate.grpc.Values;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.common.cql.builder.Column;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DataTypeMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.aggregations.AggregationsFetcherSupport;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryFetcher
extends DmlFetcher<Map<String, Object>> {
    private final AggregationsFetcherSupport aggregationsFetcherSupport;

    public QueryFetcher(String keyspaceName, Schema.CqlTable table, NameMapping nameMapping) {
        super(keyspaceName, table, nameMapping);
        this.aggregationsFetcherSupport = new AggregationsFetcherSupport(nameMapping, table);
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        QueryOuterClass.Query query = this.buildQuery(environment);
        QueryOuterClass.Response response = context.getBridge().executeQuery(query);
        QueryOuterClass.ResultSet resultSet = response.getResultSet();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", resultSet.getRowsList().stream().map(row -> {
            Map<String, Object> columns = DataTypeMapping.toGraphqlValue(this.nameMapping, this.table, resultSet.getColumnsList(), row);
            return this.aggregationsFetcherSupport.addAggregationResults(columns, environment, (QueryOuterClass.Row)row, resultSet.getColumnsList());
        }).collect(Collectors.toList()));
        if (resultSet.hasPagingState()) {
            result.put("pageState", BytesValues.toBase64(resultSet.getPagingState()));
        }
        return result;
    }

    private QueryOuterClass.Query buildQuery(DataFetchingEnvironment environment) {
        QueryOuterClass.Value limit = null;
        if (environment.containsArgument("options")) {
            Object limitObj;
            Map options = (Map)environment.getArgument("options");
            Object v0 = limitObj = options == null ? null : options.get("limit");
            if (limitObj != null) {
                limit = Values.of(((Integer)limitObj).intValue());
            }
        }
        return new QueryBuilder().select().column(this.buildQueryColumns(environment)).function(this.aggregationsFetcherSupport.buildAggregatedFunctions(environment)).from(this.keyspaceName, this.table.getName()).where(this.buildClause(this.table, environment)).limit(limit).groupBy(this.buildGroupBy(environment)).orderBy(this.buildOrderBy(environment)).parameters(this.buildParameters(environment)).build();
    }

    private List<String> buildGroupBy(DataFetchingEnvironment environment) {
        String graphqlName;
        if (!environment.containsArgument("groupBy")) {
            return Collections.emptyList();
        }
        ImmutableList.Builder groupBys = ImmutableList.builder();
        Map input = (Map)environment.getArgument("groupBy");
        for (QueryOuterClass.ColumnSpec column : this.table.getPartitionKeyColumnsList()) {
            graphqlName = this.nameMapping.getGraphqlName(this.table, column);
            if (!input.getOrDefault(graphqlName, false).booleanValue()) continue;
            groupBys.add(column.getName());
        }
        for (QueryOuterClass.ColumnSpec column : this.table.getClusteringKeyColumnsList()) {
            graphqlName = this.nameMapping.getGraphqlName(this.table, column);
            if (!input.getOrDefault(graphqlName, false).booleanValue()) continue;
            groupBys.add(column.getName());
        }
        return groupBys.build();
    }

    private Map<String, Column.Order> buildOrderBy(DataFetchingEnvironment environment) {
        if (!environment.containsArgument("orderBy")) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Column.Order> orderBy = new LinkedHashMap<String, Column.Order>();
        List orderList = (List)environment.getArgument("orderBy");
        for (String order : orderList) {
            int split2 = order.lastIndexOf("_");
            String column = order.substring(0, split2);
            boolean desc = order.substring(split2 + 1).equals("DESC");
            orderBy.put(this.dbColumnGetter.getDBColumnName(this.table, column), desc ? Column.Order.DESC : Column.Order.ASC);
        }
        return orderBy;
    }

    private String[] buildQueryColumns(DataFetchingEnvironment environment) {
        List<SelectedField> valuesFields = environment.getSelectionSet().getFields("values", new String[0]);
        if (valuesFields.isEmpty()) {
            return new String[0];
        }
        LinkedHashSet<String> queryColumns = new LinkedHashSet<String>();
        for (SelectedField valuesField : valuesFields) {
            for (SelectedField selectedField : valuesField.getSelectionSet().getFields()) {
                String column;
                if ("__typename".equals(selectedField.getName()) || (column = this.dbColumnGetter.getDBColumnName(this.table, selectedField.getName())) == null) continue;
                queryColumns.add(column);
            }
        }
        return queryColumns.toArray(new String[0]);
    }
}

