/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableList;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import java.util.List;
import java.util.function.Function;

public class DbColumnGetter {
    private static final List<Function<Schema.CqlTable, List<QueryOuterClass.ColumnSpec>>> ALL_COLUMN_GETTERS = ImmutableList.of(Schema.CqlTable::getPartitionKeyColumnsList, Schema.CqlTable::getClusteringKeyColumnsList, Schema.CqlTable::getColumnsList, Schema.CqlTable::getStaticColumnsList);
    private final NameMapping nameMapping;

    public DbColumnGetter(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    public String getDBColumnName(Schema.CqlTable table, String fieldName) {
        QueryOuterClass.ColumnSpec column = this.getColumn(table, fieldName);
        return column == null ? null : column.getName();
    }

    public QueryOuterClass.ColumnSpec getColumn(Schema.CqlTable table, String fieldName) {
        String columnName = this.nameMapping.getCqlName(table, fieldName);
        if (columnName == null) {
            return null;
        }
        for (Function<Schema.CqlTable, List<QueryOuterClass.ColumnSpec>> getter : ALL_COLUMN_GETTERS) {
            for (QueryOuterClass.ColumnSpec column : getter.apply(table)) {
                if (!columnName.equals(column.getName())) continue;
                return column;
            }
        }
        return null;
    }
}

