/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.stargate.grpc.CqlDuration;
import io.stargate.grpc.Values;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

class DataTypeMapping {
    private static final QueryOuterClass.Value NULL_VALUE = QueryOuterClass.Value.newBuilder().setNull(QueryOuterClass.Value.Null.newBuilder()).build();

    DataTypeMapping() {
    }

    static QueryOuterClass.Value toGrpcValue(QueryOuterClass.TypeSpec type, Object graphQLValue, NameMapping nameMapping) {
        if (graphQLValue == null) {
            return NULL_VALUE;
        }
        switch (type.getSpecCase()) {
            case LIST: {
                return DataTypeMapping.convertCollection(type.getList().getElement(), graphQLValue, nameMapping);
            }
            case SET: {
                return DataTypeMapping.convertCollection(type.getSet().getElement(), graphQLValue, nameMapping);
            }
            case MAP: {
                return DataTypeMapping.convertMap(type.getMap().getKey(), type.getMap().getValue(), graphQLValue, nameMapping);
            }
            case UDT: {
                return DataTypeMapping.convertUdt(type.getUdt(), graphQLValue, nameMapping);
            }
            case TUPLE: {
                return DataTypeMapping.convertTuple(type.getTuple(), graphQLValue, nameMapping);
            }
            case BASIC: {
                switch (type.getBasic()) {
                    case ASCII: 
                    case VARCHAR: {
                        return Values.of((String)graphQLValue);
                    }
                    case INET: {
                        return Values.of((InetAddress)graphQLValue);
                    }
                    case BIGINT: 
                    case COUNTER: {
                        return Values.of((Long)graphQLValue);
                    }
                    case BLOB: {
                        return Values.of((ByteBuffer)graphQLValue);
                    }
                    case BOOLEAN: {
                        return Values.of((Boolean)graphQLValue);
                    }
                    case DECIMAL: {
                        return Values.of((BigDecimal)graphQLValue);
                    }
                    case DOUBLE: {
                        return Values.of((Double)graphQLValue);
                    }
                    case FLOAT: {
                        return Values.of(((Float)graphQLValue).floatValue());
                    }
                    case INT: {
                        return Values.of(((Integer)graphQLValue).intValue());
                    }
                    case TIMESTAMP: {
                        return Values.of(((Instant)graphQLValue).toEpochMilli());
                    }
                    case UUID: 
                    case TIMEUUID: {
                        return Values.of((UUID)graphQLValue);
                    }
                    case VARINT: {
                        return Values.of((BigInteger)graphQLValue);
                    }
                    case DATE: {
                        return Values.of((LocalDate)graphQLValue);
                    }
                    case TIME: {
                        return Values.of((LocalTime)graphQLValue);
                    }
                    case SMALLINT: {
                        return Values.of((Short)graphQLValue);
                    }
                    case TINYINT: {
                        return Values.of((Byte)graphQLValue);
                    }
                    case DURATION: {
                        return Values.of((CqlDuration)graphQLValue);
                    }
                }
                throw new AssertionError((Object)("Unhandled basic type " + type.getBasic()));
            }
        }
        throw new AssertionError((Object)("Unhandled type " + type.getSpecCase()));
    }

    private static QueryOuterClass.Value convertCollection(QueryOuterClass.TypeSpec elementType, Object graphQLvalue, NameMapping nameMapping) {
        Collection graphQLCollection = (Collection)graphQLvalue;
        QueryOuterClass.Value[] dbCollection = new QueryOuterClass.Value[graphQLCollection.size()];
        int i = 0;
        for (Object element : graphQLCollection) {
            dbCollection[i] = DataTypeMapping.toGrpcValue(elementType, element, nameMapping);
            ++i;
        }
        return Values.of(dbCollection);
    }

    private static QueryOuterClass.Value convertMap(QueryOuterClass.TypeSpec keyType, QueryOuterClass.TypeSpec valueType, Object graphQLValue, NameMapping nameMapping) {
        LinkedHashMap<QueryOuterClass.Value, QueryOuterClass.Value> dbMap = new LinkedHashMap<QueryOuterClass.Value, QueryOuterClass.Value>();
        Collection graphQLMap = (Collection)graphQLValue;
        for (Map entry : graphQLMap) {
            QueryOuterClass.Value key = DataTypeMapping.toGrpcValue(keyType, entry.get("key"), nameMapping);
            QueryOuterClass.Value value = DataTypeMapping.toGrpcValue(valueType, entry.get("value"), nameMapping);
            dbMap.put(key, value);
        }
        return Values.of(dbMap);
    }

    private static QueryOuterClass.Value convertUdt(QueryOuterClass.TypeSpec.Udt udtType, Object graphQLValue, NameMapping nameMapping) {
        Map object = (Map)graphQLValue;
        QueryOuterClass.UdtValue.Builder udtValue = QueryOuterClass.UdtValue.newBuilder();
        for (Map.Entry entry : object.entrySet()) {
            String fieldName = nameMapping.getCqlName(udtType, (String)entry.getKey());
            QueryOuterClass.TypeSpec fieldType = udtType.getFieldsMap().get(fieldName);
            QueryOuterClass.Value value = DataTypeMapping.toGrpcValue(fieldType, entry.getValue(), nameMapping);
            udtValue.putFields(fieldName, value);
        }
        return QueryOuterClass.Value.newBuilder().setUdt(udtValue).build();
    }

    private static QueryOuterClass.Value convertTuple(QueryOuterClass.TypeSpec.Tuple type, Object graphQLValue, NameMapping nameMapping) {
        Map object = (Map)graphQLValue;
        QueryOuterClass.Value[] dbCollection = new QueryOuterClass.Value[object.size()];
        int i = 0;
        for (QueryOuterClass.TypeSpec subType : type.getElementsList()) {
            Object item = object.get("item" + i);
            dbCollection[i] = DataTypeMapping.toGrpcValue(subType, item, nameMapping);
            ++i;
        }
        return Values.of(dbCollection);
    }

    static Map<String, Object> toGraphqlValue(NameMapping nameMapping, Schema.CqlTable table, List<QueryOuterClass.ColumnSpec> columnSpecs, QueryOuterClass.Row row) {
        HashMap<String, Object> map = new HashMap<String, Object>(columnSpecs.size());
        int i = 0;
        for (QueryOuterClass.ColumnSpec column : columnSpecs) {
            QueryOuterClass.Value value = row.getValues(i);
            String graphqlName = nameMapping.getGraphqlName(table, column);
            if (graphqlName != null && !value.hasNull()) {
                map.put(graphqlName, DataTypeMapping.toGraphqlValue(nameMapping, column.getType(), value));
            }
            ++i;
        }
        return map;
    }

    private static Object toGraphqlValue(NameMapping nameMapping, QueryOuterClass.TypeSpec type, QueryOuterClass.Value dbValue) {
        if (dbValue.hasNull()) {
            return null;
        }
        switch (type.getSpecCase()) {
            case LIST: 
            case SET: {
                QueryOuterClass.TypeSpec elementType = type.hasList() ? type.getList().getElement() : type.getSet().getElement();
                return dbValue.getCollection().getElementsList().stream().map(e -> DataTypeMapping.toGraphqlValue(nameMapping, elementType, e)).collect(Collectors.toList());
            }
            case MAP: {
                QueryOuterClass.TypeSpec keyType = type.getMap().getKey();
                QueryOuterClass.TypeSpec valueType = type.getMap().getValue();
                List<QueryOuterClass.Value> mapElements = dbValue.getCollection().getElementsList();
                assert (mapElements.size() % 2 == 0);
                ArrayList<ImmutableMap<String, Object>> graphqlEntries = new ArrayList<ImmutableMap<String, Object>>(mapElements.size() / 2);
                for (int i = 0; i < mapElements.size(); i += 2) {
                    Object graphqlKey = DataTypeMapping.toGraphqlValue(nameMapping, keyType, mapElements.get(i));
                    Object graphqlValue = DataTypeMapping.toGraphqlValue(nameMapping, valueType, mapElements.get(i + 1));
                    graphqlEntries.add(ImmutableMap.of("key", graphqlKey, "value", graphqlValue));
                }
                return graphqlEntries;
            }
            case UDT: {
                QueryOuterClass.TypeSpec.Udt udtType = type.getUdt();
                QueryOuterClass.UdtValue udtValue = dbValue.getUdt();
                LinkedHashMap<String, Object> graphqlUdt = Maps.newLinkedHashMapWithExpectedSize(udtValue.getFieldsCount());
                for (Map.Entry<String, QueryOuterClass.Value> entry : udtValue.getFieldsMap().entrySet()) {
                    String cqlName = entry.getKey();
                    String graphqlName = nameMapping.getGraphqlName(udtType, cqlName);
                    graphqlUdt.put(graphqlName, DataTypeMapping.toGraphqlValue(nameMapping, udtType.getFieldsMap().get(cqlName), entry.getValue()));
                }
                return graphqlUdt;
            }
            case TUPLE: {
                List<QueryOuterClass.TypeSpec> fieldTypes = type.getTuple().getElementsList();
                List<QueryOuterClass.Value> dbFields = dbValue.getCollection().getElementsList();
                LinkedHashMap<String, Object> graphqlTuple = Maps.newLinkedHashMapWithExpectedSize(dbFields.size());
                for (int i = 0; i < dbFields.size(); ++i) {
                    QueryOuterClass.TypeSpec fieldType = fieldTypes.get(i);
                    graphqlTuple.put("item" + i, DataTypeMapping.toGraphqlValue(nameMapping, fieldType, dbFields.get(i)));
                }
                return graphqlTuple;
            }
            case BASIC: {
                switch (type.getBasic()) {
                    case ASCII: 
                    case VARCHAR: {
                        return Values.string(dbValue);
                    }
                    case INET: {
                        return Values.inet(dbValue);
                    }
                    case BIGINT: 
                    case COUNTER: {
                        return Values.bigint(dbValue);
                    }
                    case BLOB: {
                        return Values.byteBuffer(dbValue);
                    }
                    case BOOLEAN: {
                        return Values.bool(dbValue);
                    }
                    case DECIMAL: {
                        return Values.decimal(dbValue);
                    }
                    case DOUBLE: {
                        return Values.double_(dbValue);
                    }
                    case FLOAT: {
                        return Float.valueOf(Values.float_(dbValue));
                    }
                    case INT: {
                        return Values.int_(dbValue);
                    }
                    case TIMESTAMP: {
                        return Instant.ofEpochMilli(Values.bigint(dbValue));
                    }
                    case UUID: 
                    case TIMEUUID: {
                        return Values.uuid(dbValue);
                    }
                    case VARINT: {
                        return Values.varint(dbValue);
                    }
                    case DATE: {
                        return Values.date(dbValue);
                    }
                    case TIME: {
                        return Values.time(dbValue);
                    }
                    case SMALLINT: {
                        return Values.smallint(dbValue);
                    }
                    case TINYINT: {
                        return Values.tinyint(dbValue);
                    }
                    case DURATION: {
                        return Values.duration(dbValue);
                    }
                }
                throw new AssertionError((Object)("Unhandled basic type " + type.getBasic()));
            }
        }
        throw new AssertionError((Object)("Unhandled type " + type.getSpecCase()));
    }
}

