/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers;

import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BulkMutationFetcher
extends DmlFetcher<CompletionStage<List<Map<String, Object>>>> {
    protected BulkMutationFetcher(String keyspaceName, Schema.CqlTable table, NameMapping nameMapping) {
        super(keyspaceName, table, nameMapping);
    }

    @Override
    protected CompletionStage<List<Map<String, Object>>> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        List<Object> queries = new ArrayList();
        Exception buildException = null;
        try {
            queries = this.buildQueries(environment, context);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (this.containsDirective(operation, "atomic") && (operation.getSelectionSet().getSelections().size() > 1 || queries.size() > 1)) {
            return this.executeAsPartOfBatch(queries, buildException, operation, environment, context);
        }
        if (buildException != null) {
            CompletableFuture<List<Map<String, Object>>> f = new CompletableFuture<List<Map<String, Object>>>();
            f.completeExceptionally(buildException);
            return f;
        }
        List values = (List)environment.getArgument("values");
        assert (values.size() == queries.size());
        ArrayList results = new ArrayList(values.size());
        QueryOuterClass.QueryParameters parameters = this.buildParameters(environment);
        boolean isAsync = this.containsDirective(operation, "async");
        for (int i = 0; i < queries.size(); ++i) {
            int finalI = i;
            QueryOuterClass.Query query = QueryOuterClass.Query.newBuilder((QueryOuterClass.Query)queries.get(i)).setParameters(parameters).build();
            if (isAsync) {
                results.add(this.executeAsyncAccepted(query, values.get(finalI), context));
                continue;
            }
            results.add(context.getBridge().executeQueryAsync(query).thenApply(rs -> this.toMutationResult((QueryOuterClass.Response)rs, values.get(finalI))));
        }
        return BulkMutationFetcher.convert(results);
    }

    private CompletionStage<List<Map<String, Object>>> executeAsPartOfBatch(List<QueryOuterClass.Query> queries, Exception buildException, OperationDefinition operation, DataFetchingEnvironment environment, StargateGraphqlContext context) {
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        StargateGraphqlContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && !batchContext.setParameters(this.buildParameters(environment))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(queries) == selections) {
            batchContext.setExecutionResult(context.getBridge().executeBatchAsync(QueryOuterClass.Batch.newBuilder().addAllQueries(batchContext.getQueries()).setParameters(batchContext.getParameters()).build()));
        }
        List values = (List)environment.getArgument("values");
        if (this.containsDirective(operation, "async")) {
            return this.toListOfAcceptedMutationResults(values);
        }
        return batchContext.getExecutionFuture().thenApply(rows -> this.toBatchResults((QueryOuterClass.Response)rows, values));
    }

    public static <T> CompletionStage<List<T>> convert(List<CompletionStage<T>> futures) {
        return futures.stream().map(f -> f.thenApply(Stream::of)).reduce((a, b) -> a.thenCompose(xs -> b.thenApply(ys -> Stream.concat(xs, ys)))).map(f -> f.thenApply(s2 -> s2.collect(Collectors.toList()))).orElse(CompletableFuture.completedFuture(Collections.emptyList()));
    }

    protected abstract List<QueryOuterClass.Query> buildQueries(DataFetchingEnvironment var1, StargateGraphqlContext var2);
}

