/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.graphql.schema.CassandraFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.FieldFilterInputTypeCache;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.FieldInputTypeCache;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.FieldOutputTypeCache;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.SchemaWarningException;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.BulkInsertMutationFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.DeleteMutationFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.InsertMutationFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.QueryFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.UpdateMutationFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.fetchers.aggregations.SupportedGraphqlFunction;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmlSchemaBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DmlSchemaBuilder.class);
    private static final GraphQLInputType MUTATION_OPTIONS = GraphQLInputObjectType.newInputObject().name("MutationOptions").description("The execution options for the mutation.").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type(GraphQLEnumType.newEnum().name("MutationConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").build()).defaultValue(CassandraFetcher.DEFAULT_CONSISTENCY.getValue().name()).build()).field(GraphQLInputObjectField.newInputObjectField().name("serialConsistency").type(GraphQLEnumType.newEnum().name("SerialConsistency").value("SERIAL").value("LOCAL_SERIAL").build()).defaultValue(CassandraFetcher.DEFAULT_SERIAL_CONSISTENCY.getValue().name()).build()).field(GraphQLInputObjectField.newInputObjectField().name("ttl").type(Scalars.GraphQLInt).build()).build();
    private final Schema.CqlKeyspaceDescribe cqlSchema;
    private final String keyspaceName;
    private final List<String> warnings = new ArrayList<String>();
    private final FieldInputTypeCache fieldInputTypes;
    private final FieldOutputTypeCache fieldOutputTypes;
    private final FieldFilterInputTypeCache fieldFilterInputTypes;
    private final NameMapping nameMapping;
    private final Map<Schema.CqlTable, GraphQLOutputType> entityResultMap = new HashMap<Schema.CqlTable, GraphQLOutputType>();

    public DmlSchemaBuilder(Schema.CqlKeyspaceDescribe cqlSchema) {
        this.cqlSchema = cqlSchema;
        this.keyspaceName = cqlSchema.getCqlKeyspace().getName();
        this.nameMapping = new NameMapping(cqlSchema.getTablesList(), cqlSchema.getTypesList(), this.warnings);
        this.fieldInputTypes = new FieldInputTypeCache(this.nameMapping, this.warnings);
        this.fieldOutputTypes = new FieldOutputTypeCache(this.nameMapping, this.warnings);
        this.fieldFilterInputTypes = new FieldFilterInputTypeCache(this.fieldInputTypes, this.nameMapping);
    }

    public GraphQLSchema build() {
        GraphQLSchema.Builder builder = new GraphQLSchema.Builder();
        ArrayList<GraphQLFieldDefinition> queryFields = new ArrayList<GraphQLFieldDefinition>();
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        for (Schema.CqlTable table : this.cqlSchema.getTablesList()) {
            if (this.nameMapping.getGraphqlName(table) == null) continue;
            try {
                builder.additionalTypes(this.buildTypesForTable(table));
                queryFields.addAll(this.buildQuery(table));
                mutationFields.addAll(this.buildMutations(table));
            }
            catch (Exception e) {
                this.warn(e, "Could not convert table %s, skipping", table.getName());
            }
        }
        this.addAtomicDirective(builder);
        this.addAsyncDirective(builder);
        builder.additionalType(this.buildQueryOptionsInputType());
        queryFields.add(this.buildWarnings());
        builder.query(this.buildQueries(queryFields));
        if (mutationFields.isEmpty()) {
            GraphQLFieldDefinition emptyMutationField = GraphQLFieldDefinition.newFieldDefinition().name("keyspaceEmptyMutation").description("Placeholder mutation that is exposed when a keyspace is empty.").type(Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            mutationFields.add(emptyMutationField);
        }
        builder.mutation(this.buildMutationRoot(mutationFields));
        return builder.build();
    }

    private Set<GraphQLType> buildTypesForTable(Schema.CqlTable table) {
        HashSet<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
        additionalTypes.add(this.buildType(table));
        additionalTypes.add(this.buildInputType(table));
        additionalTypes.add(this.buildOrderType(table));
        additionalTypes.add(this.buildMutationResult(table));
        additionalTypes.add(this.buildFilterInput(table));
        additionalTypes.add(this.buildGroupByInput(table));
        return additionalTypes;
    }

    public GraphQLObjectType buildType(Schema.CqlTable table) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(this.nameMapping.getGraphqlName(table)).description(this.getTypeDescription(table, DmlType.QueryOutput));
        this.addToType(table.getPartitionKeyColumnsList(), table, builder);
        this.addToType(table.getClusteringKeyColumnsList(), table, builder);
        this.addToType(table.getColumnsList(), table, builder);
        this.addToType(table.getStaticColumnsList(), table, builder);
        this.buildAggregationFunctions(builder);
        return builder.build();
    }

    private void addToType(List<QueryOuterClass.ColumnSpec> columns, Schema.CqlTable table, GraphQLObjectType.Builder builder) {
        for (QueryOuterClass.ColumnSpec column : columns) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            try {
                GraphQLFieldDefinition.Builder fieldBuilder = new GraphQLFieldDefinition.Builder().name(graphqlName).type((GraphQLOutputType)this.fieldOutputTypes.get(column.getType()));
                builder.field(fieldBuilder.build());
            }
            catch (Exception e) {
                this.warn(e, "Could not create output type for column %s in table %s, skipping", column.getName(), table.getName());
            }
        }
    }

    private String getTypeDescription(Schema.CqlTable table, DmlType dmlType) {
        StringBuilder builder = new StringBuilder();
        switch (dmlType) {
            case Input: {
                builder.append("The input type");
                break;
            }
            case FilterInput: {
                builder.append("The input type used for filtering with non-equality operators");
                break;
            }
            case Order: {
                builder.append("The enum used to order a query result based on one or more fields");
                break;
            }
            case QueryOutput: {
                builder.append("The type used to represent results of a query");
                break;
            }
            case MutationOutput: {
                builder.append("The type used to represent results of a mutation");
                break;
            }
            default: {
                builder.append("Type");
            }
        }
        builder.append(" for the table '");
        builder.append(table.getName());
        builder.append("'.");
        if (dmlType == DmlType.Input || dmlType == DmlType.FilterInput) {
            this.primaryKeyDescription(table, builder);
        }
        return builder.toString();
    }

    private void primaryKeyDescription(Schema.CqlTable table, StringBuilder builder) {
        List primaryKeys = Stream.concat(table.getPartitionKeyColumnsList().stream(), table.getClusteringKeyColumnsList().stream()).map(c -> this.nameMapping.getGraphqlName(table, (QueryOuterClass.ColumnSpec)c)).collect(Collectors.toList());
        builder.append("\nNote that ").append("'").append((String)primaryKeys.get(0)).append("'");
        for (int i = 1; i < primaryKeys.size(); ++i) {
            if (i == primaryKeys.size() - 1) {
                builder.append(" and ");
            } else {
                builder.append(", ");
            }
            builder.append("'").append((String)primaryKeys.get(i)).append("'");
        }
        if (primaryKeys.size() > 1) {
            builder.append(" are the fields that correspond to the table primary key.");
        } else {
            builder.append(" is the field that corresponds to the table primary key.");
        }
    }

    private String primaryKeyDescription(Schema.CqlTable table) {
        StringBuilder builder = new StringBuilder();
        this.primaryKeyDescription(table, builder);
        return builder.toString();
    }

    private void buildAggregationFunctions(GraphQLObjectType.Builder builder) {
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.INT_FUNCTION, Scalars.GraphQLInt));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.DOUBLE_FUNCTION, Scalars.GraphQLFloat));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.BIGINT_FUNCTION, CqlScalar.BIGINT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.DECIMAL_FUNCTION, CqlScalar.DECIMAL.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.VARINT_FUNCTION, CqlScalar.VARINT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.FLOAT_FUNCTION, CqlScalar.FLOAT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.SMALLINT_FUNCTION, CqlScalar.SMALLINT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.TINYINT_FUNCTION, CqlScalar.TINYINT.getGraphqlType()));
    }

    private GraphQLFieldDefinition buildFunctionField(SupportedGraphqlFunction graphqlFunction, GraphQLScalarType returnType) {
        return GraphQLFieldDefinition.newFieldDefinition().name(graphqlFunction.getName()).description(String.format("Invocation of an aggregate function that returns %s.", returnType)).argument(GraphQLArgument.newArgument().name("name").description("Name of the function to invoke").type(new GraphQLNonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("args").description("Arguments passed to a function. It can be a list of column names.").type(new GraphQLNonNull(new GraphQLList(new GraphQLNonNull(Scalars.GraphQLString))))).type(returnType).build();
    }

    private GraphQLType buildInputType(Schema.CqlTable table) {
        GraphQLInputObjectType.Builder input = GraphQLInputObjectType.newInputObject().name(this.nameMapping.getGraphqlName(table) + "Input").description(this.getTypeDescription(table, DmlType.Input));
        this.addToInputType(table.getPartitionKeyColumnsList(), table, input);
        this.addToInputType(table.getClusteringKeyColumnsList(), table, input);
        this.addToInputType(table.getColumnsList(), table, input);
        this.addToInputType(table.getStaticColumnsList(), table, input);
        return input.build();
    }

    private void addToInputType(List<QueryOuterClass.ColumnSpec> columns, Schema.CqlTable table, GraphQLInputObjectType.Builder input) {
        for (QueryOuterClass.ColumnSpec column : columns) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            try {
                GraphQLInputObjectField field = GraphQLInputObjectField.newInputObjectField().name(graphqlName).type((GraphQLInputType)this.fieldInputTypes.get(column.getType())).build();
                input.field(field);
            }
            catch (Exception e) {
                this.warn(e, "Could not create input type for column %s in table %s, skipping", column.getName(), table.getName());
            }
        }
    }

    private GraphQLType buildOrderType(Schema.CqlTable table) {
        GraphQLEnumType.Builder input = GraphQLEnumType.newEnum().name(this.nameMapping.getGraphqlName(table) + "Order").description(this.getTypeDescription(table, DmlType.Order));
        this.addToOrderType(table.getPartitionKeyColumnsList(), table, input);
        this.addToOrderType(table.getClusteringKeyColumnsList(), table, input);
        this.addToOrderType(table.getColumnsList(), table, input);
        this.addToOrderType(table.getStaticColumnsList(), table, input);
        return input.build();
    }

    private void addToOrderType(List<QueryOuterClass.ColumnSpec> columns, Schema.CqlTable table, GraphQLEnumType.Builder input) {
        for (QueryOuterClass.ColumnSpec column : columns) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            input.value(graphqlName + "_DESC");
            input.value(graphqlName + "_ASC");
        }
    }

    private GraphQLOutputType buildMutationResult(Schema.CqlTable table) {
        return GraphQLObjectType.newObject().name(this.nameMapping.getGraphqlName(table) + "MutationResult").description(this.getTypeDescription(table, DmlType.MutationOutput)).field(GraphQLFieldDefinition.newFieldDefinition().name("applied").type(Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("accepted").description(String.format("This field is relevant and fulfilled with data, only when used with the @%s directive", "async")).type(Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table)))).build();
    }

    private GraphQLType buildFilterInput(Schema.CqlTable table) {
        return GraphQLInputObjectType.newInputObject().name(this.nameMapping.getGraphqlName(table) + "FilterInput").description(this.getTypeDescription(table, DmlType.FilterInput)).fields(this.buildFilterInputFields(table)).build();
    }

    private List<GraphQLInputObjectField> buildFilterInputFields(Schema.CqlTable table) {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
        this.addToFilterInputFields(table.getPartitionKeyColumnsList(), table, fields);
        this.addToFilterInputFields(table.getClusteringKeyColumnsList(), table, fields);
        this.addToFilterInputFields(table.getColumnsList(), table, fields);
        this.addToFilterInputFields(table.getStaticColumnsList(), table, fields);
        return fields;
    }

    private void addToFilterInputFields(List<QueryOuterClass.ColumnSpec> columns, Schema.CqlTable table, List<GraphQLInputObjectField> fields) {
        for (QueryOuterClass.ColumnSpec column : columns) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            try {
                fields.add(GraphQLInputObjectField.newInputObjectField().name(graphqlName).type((GraphQLInputType)this.fieldFilterInputTypes.get(column.getType())).build());
            }
            catch (Exception e) {
                this.warn(e, "Could not create filter input type for column %s in table %s, skipping", column.getName(), table.getName());
            }
        }
    }

    private GraphQLType buildGroupByInput(Schema.CqlTable table) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(this.nameMapping.getGraphqlName(table) + "GroupByInput");
        this.addToGroupByInput(table.getPartitionKeyColumnsList(), table, builder);
        this.addToGroupByInput(table.getClusteringKeyColumnsList(), table, builder);
        return builder.build();
    }

    private void addToGroupByInput(List<QueryOuterClass.ColumnSpec> columns, Schema.CqlTable table, GraphQLInputObjectType.Builder builder) {
        for (QueryOuterClass.ColumnSpec column : columns) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            builder.field(GraphQLInputObjectField.newInputObjectField().name(graphqlName).type(Scalars.GraphQLBoolean).build());
        }
    }

    private List<GraphQLFieldDefinition> buildQuery(Schema.CqlTable table) {
        String graphqlName = this.nameMapping.getGraphqlName(table);
        GraphQLFieldDefinition query = GraphQLFieldDefinition.newFieldDefinition().name(graphqlName).description(String.format("Query for the table '%s'.%s", table.getName(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type(new GraphQLTypeReference(graphqlName + "Input"))).argument(GraphQLArgument.newArgument().name("filter").type(new GraphQLTypeReference(graphqlName + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type(new GraphQLList(new GraphQLTypeReference(graphqlName + "Order")))).argument(GraphQLArgument.newArgument().name("groupBy").description("The columns to group results by.").type(new GraphQLTypeReference(graphqlName + "GroupByInput"))).argument(GraphQLArgument.newArgument().name("options").type(new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher(new QueryFetcher(this.keyspaceName, table, this.nameMapping)).build();
        GraphQLFieldDefinition filterQuery = GraphQLFieldDefinition.newFieldDefinition().name(graphqlName + "Filter").deprecate("No longer supported. Use root type instead.").argument(GraphQLArgument.newArgument().name("filter").type(new GraphQLTypeReference(graphqlName + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type(new GraphQLList(new GraphQLTypeReference(graphqlName + "Order")))).argument(GraphQLArgument.newArgument().name("options").type(new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher(new QueryFetcher(this.keyspaceName, table, this.nameMapping)).build();
        return ImmutableList.of(query, filterQuery);
    }

    private GraphQLOutputType buildEntityResultOutput(Schema.CqlTable table) {
        if (this.entityResultMap.containsKey(table)) {
            return this.entityResultMap.get(table);
        }
        GraphQLObjectType entityResultType = GraphQLObjectType.newObject().name(this.nameMapping.getGraphqlName(table) + "Result").field(GraphQLFieldDefinition.newFieldDefinition().name("pageState").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("values").type(new GraphQLList(new GraphQLNonNull(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table)))))).build();
        this.entityResultMap.put(table, entityResultType);
        return entityResultType;
    }

    private GraphQLFieldDefinition buildWarnings() {
        StringBuilder description = new StringBuilder("Warnings encountered during the CQL to GraphQL conversion.");
        if (this.warnings.isEmpty()) {
            description.append("\nNo warnings found, this will return an empty list.");
        } else {
            description.append("\nThis will return:");
            for (String warning : this.warnings) {
                description.append("\n- ").append(warning);
            }
        }
        return GraphQLFieldDefinition.newFieldDefinition().name("conversionWarnings").description(description.toString()).type(GraphQLList.list(Scalars.GraphQLString)).dataFetcher(d -> this.warnings).build();
    }

    private GraphQLType buildQueryOptionsInputType() {
        return GraphQLInputObjectType.newInputObject().name("QueryOptions").description("The execution options for the query.").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type(GraphQLEnumType.newEnum().name("QueryConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").value("SERIAL").value("LOCAL_SERIAL").build()).defaultValue(CassandraFetcher.DEFAULT_CONSISTENCY.getValue().name()).build()).field(GraphQLInputObjectField.newInputObjectField().name("limit").type(Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageSize").type(Scalars.GraphQLInt).defaultValue(100).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageState").type(Scalars.GraphQLString).build()).build();
    }

    private GraphQLObjectType buildQueries(List<GraphQLFieldDefinition> queryFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Query");
        for (GraphQLFieldDefinition fieldDefinition : queryFields) {
            builder.field(fieldDefinition);
        }
        return builder.build();
    }

    private List<GraphQLFieldDefinition> buildMutations(Schema.CqlTable table) {
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        mutationFields.add(this.buildDelete(table));
        mutationFields.add(this.buildInsert(table));
        mutationFields.add(this.buildBulkInsert(table));
        mutationFields.add(this.buildUpdate(table));
        return mutationFields;
    }

    private GraphQLFieldDefinition buildDelete(Schema.CqlTable table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("delete" + this.nameMapping.getGraphqlName(table)).description(String.format("Delete mutation for the table '%s'.%s", table.getName(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type(new GraphQLNonNull(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type(Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult")).dataFetcher(new DeleteMutationFetcher(this.keyspaceName, table, this.nameMapping)).build();
    }

    private GraphQLFieldDefinition buildInsert(Schema.CqlTable table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("insert" + this.nameMapping.getGraphqlName(table)).description(String.format("Insert mutation for the table '%s'.%s", table.getName(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type(new GraphQLNonNull(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifNotExists").type(Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult")).dataFetcher(new InsertMutationFetcher(this.keyspaceName, table, this.nameMapping)).build();
    }

    private GraphQLFieldDefinition buildBulkInsert(Schema.CqlTable table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("bulkInsert" + this.nameMapping.getGraphqlName(table)).description(String.format("Bulk insert mutations for the table '%s'.%s", table.getName(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("values").type(new GraphQLList(new GraphQLNonNull(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input"))))).argument(GraphQLArgument.newArgument().name("ifNotExists").type(Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type(new GraphQLList(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult"))).dataFetcher(new BulkInsertMutationFetcher(this.keyspaceName, table, this.nameMapping)).build();
    }

    private GraphQLFieldDefinition buildUpdate(Schema.CqlTable table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("update" + this.nameMapping.getGraphqlName(table)).description(String.format("Update mutation for the table '%s'.%s", table.getName(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type(new GraphQLNonNull(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type(Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type(new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult")).dataFetcher(new UpdateMutationFetcher(this.keyspaceName, table, this.nameMapping)).build();
    }

    private void addAtomicDirective(GraphQLSchema.Builder builder) {
        builder.additionalDirective(GraphQLDirective.newDirective().validLocation(Introspection.DirectiveLocation.MUTATION).name("atomic").description("Instructs the server to apply the mutations in a LOGGED batch").build());
    }

    private void addAsyncDirective(GraphQLSchema.Builder builder) {
        builder.additionalDirective(GraphQLDirective.newDirective().validLocation(Introspection.DirectiveLocation.MUTATION).name("async").description("Instructs the server to apply the mutations asynchronously without waiting for the result.").build());
    }

    private GraphQLObjectType buildMutationRoot(List<GraphQLFieldDefinition> mutationFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Mutation");
        for (GraphQLFieldDefinition mutation : mutationFields) {
            builder.field(mutation);
        }
        return builder.build();
    }

    @FormatMethod
    private void warn(Exception e, @FormatString String format, Object ... arguments) {
        String message = String.format(format, arguments);
        this.warnings.add(message + " (" + e.getMessage() + ")");
        if (!(e instanceof SchemaWarningException)) {
            LOG.warn(message, e);
        }
    }

    private static enum DmlType {
        QueryOutput,
        MutationOutput,
        Input,
        FilterInput,
        Order;

    }
}

