/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KeyspaceDto {
    private static final Splitter.MapSplitter REPLICATION_SPLITTER = Splitter.on(',').trimResults(CharMatcher.anyOf("{} ")).withKeyValueSeparator(Splitter.on(':').trimResults(CharMatcher.anyOf("' ")));
    private final Schema.CqlKeyspace keyspace;
    private final List<QueryOuterClass.TypeSpec.Udt> udts;
    private final StargateBridgeClient bridge;

    public KeyspaceDto(Schema.CqlKeyspaceDescribe keyspaceDescribe, StargateBridgeClient bridge) {
        this.keyspace = keyspaceDescribe.getCqlKeyspace();
        this.udts = keyspaceDescribe.getTypesList();
        this.bridge = bridge;
    }

    public String getName() {
        return this.keyspace.getName();
    }

    public List<Map<String, String>> getDcs() {
        String replication = this.keyspace.getOptionsMap().get("replication");
        if (replication == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> dcs = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, String> entries : REPLICATION_SPLITTER.split(replication).entrySet()) {
            if (entries.getKey().equals("class") || entries.getKey().equals("replication_factor")) continue;
            dcs.add(ImmutableMap.of("name", entries.getKey(), "replicas", entries.getValue()));
        }
        return dcs;
    }

    public List<Map<String, Object>> getTables() {
        return this.bridge.getTables(this.keyspace.getName()).stream().map(KeyspaceDto::buildTable).collect(Collectors.toList());
    }

    public Map<String, Object> getTable(DataFetchingEnvironment environment) {
        String name = (String)environment.getArgument("name");
        return this.bridge.getTable(this.keyspace.getName(), name, true).map(KeyspaceDto::buildTable).orElse(null);
    }

    public List<Map<String, Object>> getTypes() {
        return this.udts.stream().map(KeyspaceDto::buildUdt).collect(Collectors.toList());
    }

    public Map<String, Object> getType(DataFetchingEnvironment environment) {
        String name = (String)environment.getArgument("name");
        return this.udts.stream().filter(u -> name.equals(u.getName())).findFirst().map(KeyspaceDto::buildUdt).orElse(null);
    }

    private static Map<String, Object> buildTable(Schema.CqlTable table) {
        ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
        KeyspaceDto.buildColumns(table.getPartitionKeyColumnsList(), "PARTITION", columns);
        KeyspaceDto.buildColumns(table.getClusteringKeyColumnsList(), "CLUSTERING", columns);
        KeyspaceDto.buildColumns(table.getColumnsList(), "REGULAR", columns);
        KeyspaceDto.buildColumns(table.getStaticColumnsList(), "STATIC", columns);
        return ImmutableMap.of("name", table.getName(), "columns", columns);
    }

    private static void buildColumns(List<QueryOuterClass.ColumnSpec> columns, String kind, List<Map<String, Object>> acc) {
        columns.forEach(c -> acc.add(KeyspaceDto.buildColumn(c, kind)));
    }

    private static Map<String, Object> buildColumn(QueryOuterClass.ColumnSpec column, String kind) {
        return ImmutableMap.of("kind", kind, "name", column.getName(), "type", KeyspaceDto.buildDataType(column.getType()));
    }

    private static Map<String, Object> buildUdt(QueryOuterClass.TypeSpec.Udt type) {
        return ImmutableMap.of("name", type.getName(), "fields", KeyspaceDto.buildFields(type.getFieldsMap()));
    }

    private static List<Map<String, Object>> buildFields(Map<String, QueryOuterClass.TypeSpec> fields) {
        return fields.entrySet().stream().map(e -> ImmutableMap.of("name", e.getKey(), "type", KeyspaceDto.buildDataType((QueryOuterClass.TypeSpec)e.getValue()))).collect(Collectors.toList());
    }

    private static Map<String, Object> buildDataType(QueryOuterClass.TypeSpec typeSpec) {
        switch (typeSpec.getSpecCase()) {
            case UDT: {
                QueryOuterClass.TypeSpec.Udt udt = typeSpec.getUdt();
                return ImmutableMap.of("basic", "UDT", "info", ImmutableMap.of("name", udt.getName(), "frozen", udt.getFrozen()));
            }
            case LIST: {
                QueryOuterClass.TypeSpec.List list = typeSpec.getList();
                return KeyspaceDto.buildParameterizedType("LIST", list.getFrozen(), list.getElement());
            }
            case SET: {
                QueryOuterClass.TypeSpec.Set set = typeSpec.getSet();
                return KeyspaceDto.buildParameterizedType("SET", set.getFrozen(), set.getElement());
            }
            case MAP: {
                QueryOuterClass.TypeSpec.Map map = typeSpec.getMap();
                return KeyspaceDto.buildParameterizedType("MAP", map.getFrozen(), map.getKey(), map.getValue());
            }
            case TUPLE: {
                QueryOuterClass.TypeSpec.Tuple tuple = typeSpec.getTuple();
                return KeyspaceDto.buildParameterizedType("TUPLE", true, tuple.getElementsList().toArray(new QueryOuterClass.TypeSpec[0]));
            }
            case BASIC: {
                QueryOuterClass.TypeSpec.Basic grpc = typeSpec.getBasic();
                String graphql = grpc == QueryOuterClass.TypeSpec.Basic.VARCHAR ? "TEXT" : grpc.name().toUpperCase();
                return ImmutableMap.of("basic", graphql);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + typeSpec);
    }

    private static Map<String, Object> buildParameterizedType(String basic, boolean frozen, QueryOuterClass.TypeSpec ... subTypes) {
        return ImmutableMap.of("basic", basic, "info", ImmutableMap.of("subTypes", Arrays.stream(subTypes).map(KeyspaceDto::buildDataType).collect(Collectors.toList()), "frozen", frozen));
    }
}

