/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.ddl;

import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.AllKeyspacesFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.AlterTableAddFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.AlterTableDropFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.CreateIndexFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.CreateKeyspaceFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.CreateTableFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.CreateTypeFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.DropIndexFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.DropKeyspaceFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.DropTableFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.DropTypeFetcher;
import io.stargate.sgv2.graphql.schema.cqlfirst.ddl.fetchers.SingleKeyspaceFetcher;
import java.util.HashMap;

public class DdlSchemaBuilder {
    private final HashMap<String, GraphQLType> objects = new HashMap();

    public GraphQLSchema build() {
        return new GraphQLSchema.Builder().mutation(this.buildMutation(this.buildCreateTable(), this.buildAlterTableAdd(), this.buildAlterTableDrop(), this.buildDropTable(), this.buildCreateType(), this.buildDropType(), this.buildCreateIndex(), this.buildDropIndex(), this.buildCreateKeyspace(), this.buildDropKeyspace())).query(this.buildQuery(this.buildKeyspaceByName(), this.buildKeyspaces())).build();
    }

    private GraphQLFieldDefinition buildAlterTableAdd() {
        return GraphQLFieldDefinition.newFieldDefinition().name("alterTableAdd").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("toAdd").type(GraphQLNonNull.nonNull(GraphQLList.list(this.buildColumnInput())))).type(Scalars.GraphQLBoolean).dataFetcher(new AlterTableAddFetcher()).build();
    }

    private GraphQLFieldDefinition buildAlterTableDrop() {
        return GraphQLFieldDefinition.newFieldDefinition().name("alterTableDrop").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("toDrop").type(GraphQLNonNull.nonNull(GraphQLList.list(Scalars.GraphQLString)))).type(Scalars.GraphQLBoolean).dataFetcher(new AlterTableDropFetcher()).build();
    }

    private GraphQLFieldDefinition buildDropTable() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropTable").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("ifExists").type(Scalars.GraphQLBoolean)).type(Scalars.GraphQLBoolean).dataFetcher(new DropTableFetcher()).build();
    }

    private GraphQLFieldDefinition buildCreateType() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createType").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("typeName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("fields").type(GraphQLNonNull.nonNull(GraphQLList.list(this.buildColumnInput())))).argument(GraphQLArgument.newArgument().name("ifNotExists").type(Scalars.GraphQLBoolean)).type(Scalars.GraphQLBoolean).dataFetcher(new CreateTypeFetcher()).build();
    }

    private GraphQLFieldDefinition buildDropType() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropType").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("typeName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("ifExists").type(Scalars.GraphQLBoolean)).type(Scalars.GraphQLBoolean).dataFetcher(new DropTypeFetcher()).build();
    }

    private GraphQLFieldDefinition buildCreateKeyspace() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createKeyspace").description("Creates a new CQL keyspace").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).description("The name of the keyspace")).argument(GraphQLArgument.newArgument().name("ifNotExists").type(Scalars.GraphQLBoolean).description("Whether the operation will succeed if the keyspace already exists. Defaults to false if absent.")).argument(GraphQLArgument.newArgument().name("replicas").type(Scalars.GraphQLInt).description("Enables SimpleStrategy replication with the given replication factor. You must specify either this or 'datacenters', but not both.")).argument(GraphQLArgument.newArgument().name("datacenters").type(GraphQLList.list(this.buildDataCenterInput())).description("Enables NetworkTopologyStrategy with the given replication factors per DC. (at least one DC must be specified).You must specify either this or 'replicas', but not both.").build()).type(Scalars.GraphQLBoolean).dataFetcher(new CreateKeyspaceFetcher()).build();
    }

    private GraphQLFieldDefinition buildDropKeyspace() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropKeyspace").description("Drops a CQL keyspace").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).description("The name of the keyspace")).argument(GraphQLArgument.newArgument().name("ifExists").type(Scalars.GraphQLBoolean).description("Whether the operation will succeed if the keyspace does not exist. Defaults to false if absent.")).type(Scalars.GraphQLBoolean).dataFetcher(new DropKeyspaceFetcher()).build();
    }

    private GraphQLObjectType buildQuery(GraphQLFieldDefinition ... defs) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Query");
        for (GraphQLFieldDefinition def : defs) {
            builder.field(def);
        }
        return builder.build();
    }

    private GraphQLFieldDefinition buildKeyspaceByName() {
        return GraphQLFieldDefinition.newFieldDefinition().name("keyspace").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).type(this.buildKeyspace()).dataFetcher(new SingleKeyspaceFetcher()).build();
    }

    private GraphQLObjectType buildKeyspace() {
        return this.register(GraphQLObjectType.newObject().name("Keyspace").field(GraphQLFieldDefinition.newFieldDefinition().name("dcs").type(GraphQLList.list(this.buildDataCenter()))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("table").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).build()).type(this.buildTableType())).field(GraphQLFieldDefinition.newFieldDefinition().name("tables").type(GraphQLList.list(this.buildTableType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).build()).type(this.buildUdtType())).field(GraphQLFieldDefinition.newFieldDefinition().name("types").type(GraphQLList.list(this.buildUdtType()))).build());
    }

    private GraphQLObjectType buildTableType() {
        return this.register(GraphQLObjectType.newObject().name("Table").field(GraphQLFieldDefinition.newFieldDefinition().name("columns").type(GraphQLList.list(this.buildColumnType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).build());
    }

    private GraphQLObjectType buildUdtType() {
        return this.register(GraphQLObjectType.newObject().name("Type").field(GraphQLFieldDefinition.newFieldDefinition().name("fields").type(GraphQLList.list(this.buildFieldType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).build());
    }

    private GraphQLType buildColumnType() {
        return this.register(GraphQLObjectType.newObject().name("Column").field(GraphQLFieldDefinition.newFieldDefinition().name("kind").type(this.buildColumnKind())).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(this.buildDataType()))).build());
    }

    private GraphQLType buildFieldType() {
        return this.register(GraphQLObjectType.newObject().name("Field").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(this.buildDataType()))).build());
    }

    private GraphQLType buildDataType() {
        return this.register(GraphQLObjectType.newObject().name("DataType").field(GraphQLFieldDefinition.newFieldDefinition().name("basic").type(GraphQLNonNull.nonNull(this.buildBasicType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("info").type(this.buildDataTypeInfo())).build());
    }

    private GraphQLOutputType buildDataTypeInfo() {
        return this.register(GraphQLObjectType.newObject().name("DataTypeInfo").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("subTypes").type(GraphQLList.list(new GraphQLTypeReference("DataType")))).field(GraphQLFieldDefinition.newFieldDefinition().name("frozen").type(Scalars.GraphQLBoolean)).build());
    }

    private GraphQLEnumType buildColumnKind() {
        return this.register(GraphQLEnumType.newEnum().name("ColumnKind").value("COMPACT").value("UNKNOWN").value("PARTITION").value("CLUSTERING").value("REGULAR").value("STATIC").build());
    }

    private GraphQLObjectType buildDataCenter() {
        return this.register(GraphQLObjectType.newObject().name("DataCenter").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("replicas").type(GraphQLNonNull.nonNull(Scalars.GraphQLInt))).build());
    }

    private GraphQLInputObjectType buildDataCenterInput() {
        return this.register(GraphQLInputObjectType.newInputObject().name("DataCenterInput").description("The DC-level replication options passed to 'createKeyspace.datacenters'.").field(GraphQLInputObjectField.newInputObjectField().name("name").description("The name of the datacenter.").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLInputObjectField.newInputObjectField().name("replicas").description("The replication factor for this datacenter.").type(Scalars.GraphQLInt)).build());
    }

    private GraphQLFieldDefinition buildKeyspaces() {
        return GraphQLFieldDefinition.newFieldDefinition().name("keyspaces").type(GraphQLList.list(this.buildKeyspace())).dataFetcher(new AllKeyspacesFetcher()).build();
    }

    private GraphQLObjectType buildMutation(GraphQLFieldDefinition ... defs) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Mutation");
        for (GraphQLFieldDefinition def : defs) {
            builder.field(def);
        }
        return builder.build();
    }

    private GraphQLFieldDefinition buildCreateTable() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createTable").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("partitionKeys").type(GraphQLNonNull.nonNull(GraphQLList.list(this.buildColumnInput())))).argument(GraphQLArgument.newArgument().name("clusteringKeys").type(GraphQLList.list(this.buildClusteringKeyInput()))).argument(GraphQLArgument.newArgument().name("values").type(GraphQLList.list(this.buildColumnInput()))).argument(GraphQLArgument.newArgument().name("ifNotExists").type(Scalars.GraphQLBoolean)).type(Scalars.GraphQLBoolean).dataFetcher(new CreateTableFetcher()).build();
    }

    private GraphQLFieldDefinition buildCreateIndex() {
        return GraphQLFieldDefinition.newFieldDefinition().name("createIndex").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("tableName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("columnName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("indexName").type(Scalars.GraphQLString)).argument(GraphQLArgument.newArgument().name("indexType").description("Adds a custom index type that can be identified by name (e.g., StorageAttachedIndex), or class name (e.g., org.apache.cassandra.index.sasi.SASIIndex) ").type(Scalars.GraphQLString)).argument(GraphQLArgument.newArgument().name("ifNotExists").type(Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("indexKind").description("KEYS (indexes keys of a map), ENTRIES (index entries of a map), VALUES (index values of a collection), FULL (full index of a frozen collection)").type(this.buildIndexKind())).type(Scalars.GraphQLBoolean).dataFetcher(new CreateIndexFetcher()).build();
    }

    private GraphQLFieldDefinition buildDropIndex() {
        return GraphQLFieldDefinition.newFieldDefinition().name("dropIndex").argument(GraphQLArgument.newArgument().name("keyspaceName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("indexName").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("ifExists").type(Scalars.GraphQLBoolean)).type(Scalars.GraphQLBoolean).dataFetcher(new DropIndexFetcher()).build();
    }

    private GraphQLEnumType buildIndexKind() {
        return this.register(GraphQLEnumType.newEnum().name("IndexKind").value("KEYS").value("VALUES").value("ENTRIES").value("FULL").build());
    }

    private GraphQLInputObjectType buildClusteringKeyInput() {
        return this.register(GraphQLInputObjectType.newInputObject().name("ClusteringKeyInput").field(GraphQLInputObjectField.newInputObjectField().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLInputObjectField.newInputObjectField().name("type").type(GraphQLNonNull.nonNull(this.buildDataTypeInput()))).field(GraphQLInputObjectField.newInputObjectField().name("order").type(Scalars.GraphQLString)).build());
    }

    private GraphQLInputObjectType buildColumnInput() {
        return this.register(GraphQLInputObjectType.newInputObject().name("ColumnInput").field(GraphQLInputObjectField.newInputObjectField().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLInputObjectField.newInputObjectField().name("type").type(GraphQLNonNull.nonNull(this.buildDataTypeInput()))).build());
    }

    private GraphQLInputObjectType buildDataTypeInput() {
        return this.register(GraphQLInputObjectType.newInputObject().name("DataTypeInput").field(GraphQLInputObjectField.newInputObjectField().name("info").type(this.buildDataTypeInfoInput())).field(GraphQLInputObjectField.newInputObjectField().name("basic").type(GraphQLNonNull.nonNull(this.buildBasicType()))).build());
    }

    private GraphQLInputType buildBasicType() {
        return this.register(GraphQLEnumType.newEnum().name("BasicType").value("CUSTOM").value("INT").value("TIMEUUID").value("TIMESTAMP").value("UDT").value("BIGINT").value("TIME").value("DURATION").value("VARINT").value("UUID").value("BOOLEAN").value("TINYINT").value("SMALLINT").value("INET").value("ASCII").value("DECIMAL").value("BLOB").value("LIST").value("MAP").value("VARCHAR").value("TUPLE").value("DOUBLE").value("COUNTER").value("DATE").value("TEXT").value("FLOAT").value("SET").build());
    }

    private GraphQLInputObjectType buildDataTypeInfoInput() {
        return this.register(GraphQLInputObjectType.newInputObject().name("DataTypeInfoInput").field(GraphQLInputObjectField.newInputObjectField().name("subTypes").type(GraphQLList.list(new GraphQLTypeReference("DataTypeInput")))).field(GraphQLInputObjectField.newInputObjectField().name("name").type(Scalars.GraphQLString)).field(GraphQLInputObjectField.newInputObjectField().name("frozen").type(Scalars.GraphQLBoolean).build()).build());
    }

    private <T extends GraphQLType> T register(T object) {
        String name = this.getName(object);
        if (name == null) {
            throw new RuntimeException("Schema object has no name" + object);
        }
        GraphQLType existing = this.objects.putIfAbsent(name, object);
        return (T)(existing == null ? object : existing);
    }

    private String getName(GraphQLType object) {
        if (object instanceof GraphQLInputObjectType) {
            return ((GraphQLInputObjectType)object).getName();
        }
        if (object instanceof GraphQLObjectType) {
            return ((GraphQLObjectType)object).getName();
        }
        if (object instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)object).getName();
        }
        return null;
    }
}

