/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class Uuids {
    private static final long START_EPOCH = Uuids.makeEpoch();
    private static final long CLOCK_SEQ_AND_NODE = Uuids.makeClockSeqAndNode();
    private static final AtomicLong lastTimestamp = new AtomicLong(0L);

    private Uuids() {
    }

    public static UUID timeBased() {
        return new UUID(Uuids.makeMsb(Uuids.getCurrentTimestamp()), CLOCK_SEQ_AND_NODE);
    }

    public static long unixTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException(String.format("Can only retrieve the unix timestamp for version 1 uuid (provided version %d)", uuid.version()));
        }
        long timestamp = uuid.timestamp();
        return timestamp / 10000L + START_EPOCH;
    }

    private static long makeMsb(long timestamp) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & timestamp) << 32;
        msb |= (0xFFFF00000000L & timestamp) >>> 16;
        msb |= (0xFFF000000000000L & timestamp) >>> 48;
        return msb |= 0x1000L;
    }

    private static long getCurrentTimestamp() {
        long candidate;
        while (true) {
            long last;
            long now;
            if ((now = Uuids.fromUnixTimestamp(System.currentTimeMillis())) > (last = lastTimestamp.get())) {
                if (!lastTimestamp.compareAndSet(last, now)) continue;
                return now;
            }
            long lastMillis = Uuids.millisOf(last);
            if (Uuids.millisOf(now) < Uuids.millisOf(last)) {
                return lastTimestamp.incrementAndGet();
            }
            candidate = last + 1L;
            if (Uuids.millisOf(candidate) == lastMillis && lastTimestamp.compareAndSet(last, candidate)) break;
        }
        return candidate;
    }

    private static long fromUnixTimestamp(long tstamp) {
        return (tstamp - START_EPOCH) * 10000L;
    }

    private static long millisOf(long timestamp) {
        return timestamp / 10000L;
    }

    private static long makeEpoch() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"));
        c.set(1, 1582);
        c.set(2, 9);
        c.set(5, 15);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    private static long makeClockSeqAndNode() {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        long node = Uuids.makeNode();
        long lsb = 0L;
        lsb |= (clock & 0x3FFFL) << 48;
        lsb |= Long.MIN_VALUE;
        return lsb |= node;
    }

    private static long makeNode() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String address : Uuids.getAllLocalAddresses()) {
                Uuids.update(digest, address);
            }
            Properties props = System.getProperties();
            Uuids.update(digest, props.getProperty("java.vendor"));
            Uuids.update(digest, props.getProperty("java.vendor.url"));
            Uuids.update(digest, props.getProperty("java.version"));
            Uuids.update(digest, props.getProperty("os.arch"));
            Uuids.update(digest, props.getProperty("os.name"));
            Uuids.update(digest, props.getProperty("os.version"));
            Uuids.update(digest, Uuids.getProcessPiece());
            byte[] hash = digest.digest();
            long node = 0L;
            for (int i = 0; i < 6; ++i) {
                node |= (0xFFL & (long)hash[i]) << i * 8;
            }
            return node | 0x10000000000L;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> getAllLocalAddresses() {
        HashSet<String> allIps = new HashSet<String>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            allIps.add(localhost.toString());
            allIps.add(localhost.getCanonicalHostName());
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (InetAddress allMyIp : allMyIps) {
                    allIps.add(allMyIp.toString());
                }
            }
        }
        catch (UnknownHostException localhost) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    Enumeration<InetAddress> enumIpAddr = en.nextElement().getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        allIps.add(enumIpAddr.nextElement().toString());
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return allIps;
    }

    private static void update(MessageDigest digest, String value) {
        if (value != null) {
            digest.update(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static String getProcessPiece() {
        int pid;
        try {
            String pidJmx = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            pid = Integer.parseInt(pidJmx);
        }
        catch (Exception e) {
            pid = new Random().nextInt();
        }
        ClassLoader loader = Uuids.class.getClassLoader();
        int loaderId = loader != null ? System.identityHashCode(loader) : 0;
        return Integer.toHexString(pid) + Integer.toHexString(loaderId);
    }
}

