/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.impl;

import io.dropwizard.Configuration;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlServiceServerConfiguration
extends Configuration {
    public StargateConfiguration stargate = new StargateConfiguration();

    public static class BridgeConfiguration {
        private static final Logger LOG = LoggerFactory.getLogger(BridgeConfiguration.class);
        public String host = "localhost";
        public int port = 8091;
        public boolean useTls = false;

        public ManagedChannel buildChannel() {
            LOG.info("Bridge endpoint for GraphqlService v2 is to use: {}", (Object)this);
            Object builder = ManagedChannelBuilder.forAddress(this.host, this.port).directExecutor();
            builder = this.useTls ? ((ManagedChannelBuilder)builder).useTransportSecurity() : ((ManagedChannelBuilder)builder).usePlaintext();
            return ((ManagedChannelBuilder)builder).build();
        }

        public String toString() {
            return String.format("%s://%s:%s", this.useTls ? "https" : "http", this.host, this.port);
        }
    }

    static class StargateConfiguration {
        public BridgeConfiguration bridge = new BridgeConfiguration();

        StargateConfiguration() {
        }
    }
}

