/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.impl;

import io.dropwizard.Application;
import io.dropwizard.configuration.ResourceConfigurationSourceProvider;
import io.dropwizard.forms.MultiPartBundle;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.core.metrics.api.MetricsScraper;
import io.stargate.proto.Schema;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.common.grpc.StargateBridgeClientFactory;
import io.stargate.sgv2.common.http.CreateStargateBridgeClientFilter;
import io.stargate.sgv2.common.http.StargateBridgeClientJerseyFactory;
import io.stargate.sgv2.graphql.impl.GraphqlServiceServerConfiguration;
import io.stargate.sgv2.graphql.resources.HealthResource;
import io.stargate.sgv2.graphql.resources.MetricsResource;
import io.stargate.sgv2.graphql.web.resources.DdlResource;
import io.stargate.sgv2.graphql.web.resources.DmlResource;
import io.stargate.sgv2.graphql.web.resources.GraphqlCache;
import io.stargate.sgv2.graphql.web.resources.PlaygroundResource;
import java.util.Collections;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class GraphqlServiceServer
extends Application<GraphqlServiceServerConfiguration> {
    public static final String MODULE_NAME = "sgv2-graphqlapi";
    private final Metrics metrics;
    private final MetricsScraper metricsScraper;
    private final HttpMetricsTagProvider httpMetricsTagProvider;
    private final boolean disablePlayground;
    private final boolean disableDefaultKeyspace;

    public GraphqlServiceServer(Metrics metrics, MetricsScraper metricsScraper, HttpMetricsTagProvider httpMetricsTagProvider, boolean enableGraphqlPlayground, boolean disableDefaultKeyspace) {
        this.metrics = metrics;
        this.metricsScraper = metricsScraper;
        this.httpMetricsTagProvider = httpMetricsTagProvider;
        this.disablePlayground = enableGraphqlPlayground;
        this.disableDefaultKeyspace = disableDefaultKeyspace;
    }

    @Override
    public void run(GraphqlServiceServerConfiguration config, Environment environment) {
        JerseyEnvironment jersey = environment.jersey();
        StargateBridgeClientFactory clientFactory = StargateBridgeClientFactory.newInstance(config.stargate.bridge.buildChannel(), Schema.SchemaRead.SourceApi.GRAPHQL);
        jersey.register(this.buildClientFilter(clientFactory));
        final GraphqlCache graphqlCache = new GraphqlCache(this.disableDefaultKeyspace);
        jersey.register(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(GraphqlServiceServer.this.metricsScraper).to(MetricsScraper.class);
                this.bindFactory(StargateBridgeClientJerseyFactory.class).to(StargateBridgeClient.class).in(PerLookup.class);
                this.bind(graphqlCache).to(GraphqlCache.class);
            }
        });
        environment.jersey().register(DdlResource.class);
        environment.jersey().register(DmlResource.class);
        if (!this.disablePlayground) {
            environment.jersey().register(PlaygroundResource.class);
        }
        environment.jersey().register(HealthResource.class);
        environment.jersey().register(MetricsResource.class);
        this.enableCors(environment);
    }

    private CreateStargateBridgeClientFilter buildClientFilter(StargateBridgeClientFactory clientFactory) {
        return new CreateStargateBridgeClientFilter(clientFactory){

            @Override
            protected Response buildError(Response.Status status, String message, MediaType mediaType) {
                String entity = mediaType != null && ("json".equals(mediaType.getSubtype()) || "graphql".equals(mediaType.getSubtype())) ? Collections.singletonMap("errors", Collections.singletonList(message)) : message;
                return Response.status(status).entity(entity).build();
            }
        };
    }

    @Override
    public void initialize(Bootstrap<GraphqlServiceServerConfiguration> bootstrap) {
        super.initialize(bootstrap);
        bootstrap.setConfigurationSourceProvider(new ResourceConfigurationSourceProvider());
        bootstrap.setMetricRegistry(this.metrics.getRegistry(MODULE_NAME));
        bootstrap.addBundle(new MultiPartBundle());
    }

    private void enableCors(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("cors", CrossOriginFilter.class);
        filter.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,PATCH");
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "*");
        filter.setInitParameter("allowCredentials", "true");
        filter.setInitParameter("exposedHeaders", "Date");
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, "/*");
    }

    @Override
    protected void bootstrapLogging() {
    }
}

