/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.grpc.proto;

import io.stargate.grpc.Values;
import io.stargate.proto.QueryOuterClass;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;

public class Rows {
    public static int getInt(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::int_);
    }

    public static long getBigint(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::bigint);
    }

    public static short getSmallint(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::smallint);
    }

    public static byte getTinyint(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::tinyint);
    }

    public static float getFloat(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::float_).floatValue();
    }

    public static double getDouble(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::double_);
    }

    public static BigDecimal getDecimal(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::decimal);
    }

    public static BigInteger getVarint(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns) {
        return Rows.getBasic(row, name, columns, Values::varint);
    }

    public static int firstIndexOf(String name, List<QueryOuterClass.ColumnSpec> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            QueryOuterClass.ColumnSpec column = columns.get(i);
            if (!column.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static <V> V getBasic(QueryOuterClass.Row row, String name, List<QueryOuterClass.ColumnSpec> columns, Function<QueryOuterClass.Value, V> getter) {
        int i = Rows.firstIndexOf(name, columns);
        if (i < 0) {
            throw new IllegalArgumentException(String.format("Column '%s' does not exist", name));
        }
        QueryOuterClass.Value value = row.getValues(i);
        return getter.apply(value);
    }

    private Rows() {
    }
}

