/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.grpc;

import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.sgv2.common.futures.Futures;
import io.stargate.sgv2.common.grpc.UnauthorizedKeyspaceException;
import io.stargate.sgv2.common.grpc.UnauthorizedTableException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface StargateBridgeClient {
    public CompletionStage<QueryOuterClass.Response> executeQueryAsync(QueryOuterClass.Query var1);

    default public QueryOuterClass.Response executeQuery(QueryOuterClass.Query query) {
        return Futures.getUninterruptibly(this.executeQueryAsync(query));
    }

    public CompletionStage<QueryOuterClass.Response> executeBatchAsync(QueryOuterClass.Batch var1);

    default public QueryOuterClass.Response executeBatch(QueryOuterClass.Batch batch) {
        return Futures.getUninterruptibly(this.executeBatchAsync(batch));
    }

    public CompletionStage<Optional<Schema.CqlKeyspaceDescribe>> getKeyspaceAsync(String var1, boolean var2);

    default public Optional<Schema.CqlKeyspaceDescribe> getKeyspace(String keyspaceName, boolean checkIfAuthorized) throws UnauthorizedKeyspaceException {
        return Futures.getUninterruptibly(this.getKeyspaceAsync(keyspaceName, checkIfAuthorized));
    }

    public CompletionStage<List<Schema.CqlKeyspaceDescribe>> getAllKeyspacesAsync();

    default public List<Schema.CqlKeyspaceDescribe> getAllKeyspaces() {
        return Futures.getUninterruptibly(this.getAllKeyspacesAsync());
    }

    public String decorateKeyspaceName(String var1);

    public CompletionStage<Optional<Schema.CqlTable>> getTableAsync(String var1, String var2, boolean var3);

    default public Optional<Schema.CqlTable> getTable(String keyspaceName, String tableName, boolean checkIfAuthorized) throws UnauthorizedTableException {
        return Futures.getUninterruptibly(this.getTableAsync(keyspaceName, tableName, checkIfAuthorized));
    }

    public CompletionStage<List<Schema.CqlTable>> getTablesAsync(String var1);

    default public List<Schema.CqlTable> getTables(String keyspaceName) {
        return Futures.getUninterruptibly(this.getTablesAsync(keyspaceName));
    }

    public CompletionStage<List<Boolean>> authorizeSchemaReadsAsync(List<Schema.SchemaRead> var1);

    default public List<Boolean> authorizeSchemaReads(List<Schema.SchemaRead> schemaReads) {
        return Futures.getUninterruptibly(this.authorizeSchemaReadsAsync(schemaReads));
    }

    default public CompletionStage<Boolean> authorizeSchemaReadAsync(Schema.SchemaRead schemaRead) {
        return this.authorizeSchemaReadsAsync(Collections.singletonList(schemaRead)).thenApply(l -> (Boolean)l.get(0));
    }

    default public boolean authorizeSchemaRead(Schema.SchemaRead schemaRead) {
        return this.authorizeSchemaReads(Collections.singletonList(schemaRead)).get(0);
    }
}

