/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.grpc;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Int32Value;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.MetadataUtils;
import io.stargate.grpc.StargateBearerToken;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.proto.StargateBridgeGrpc;
import io.stargate.sgv2.common.futures.Futures;
import io.stargate.sgv2.common.grpc.SchemaReads;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.common.grpc.UnaryStreamObserver;
import io.stargate.sgv2.common.grpc.UnauthorizedKeyspaceException;
import io.stargate.sgv2.common.grpc.UnauthorizedTableException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;

class DefaultStargateBridgeClient
implements StargateBridgeClient {
    private static final int TIMEOUT_SECONDS = 5;
    private static final Metadata.Key<String> HOST_KEY = Metadata.Key.of("Host", Metadata.ASCII_STRING_MARSHALLER);
    static final QueryOuterClass.Query SELECT_KEYSPACE_NAMES = QueryOuterClass.Query.newBuilder().setCql("SELECT keyspace_name FROM system_schema.keyspaces").build();
    private final Channel channel;
    private final CallOptions callOptions;
    private final String tenantPrefix;
    private final Cache<String, Schema.CqlKeyspaceDescribe> keyspaceCache;
    private final Schema.SchemaRead.SourceApi sourceApi;

    DefaultStargateBridgeClient(Channel channel, String authToken, Optional<String> tenantId, Cache<String, Schema.CqlKeyspaceDescribe> keyspaceCache, Schema.SchemaRead.SourceApi sourceApi) {
        this.channel = tenantId.map(i -> this.addMetadata(channel, (String)i)).orElse(channel);
        this.callOptions = CallOptions.DEFAULT.withDeadlineAfter(5L, TimeUnit.SECONDS).withCallCredentials(new StargateBearerToken(authToken));
        this.tenantPrefix = tenantId.map(this::encodeKeyspacePrefix).orElse("");
        this.keyspaceCache = keyspaceCache;
        this.sourceApi = sourceApi;
    }

    @Override
    public CompletionStage<QueryOuterClass.Response> executeQueryAsync(QueryOuterClass.Query query) {
        ClientCall<QueryOuterClass.Query, QueryOuterClass.Response> call = this.channel.newCall(StargateBridgeGrpc.getExecuteQueryMethod(), this.callOptions);
        UnaryStreamObserver observer = new UnaryStreamObserver();
        ClientCalls.asyncUnaryCall(call, query, observer);
        return observer.asFuture();
    }

    @Override
    public CompletionStage<QueryOuterClass.Response> executeBatchAsync(QueryOuterClass.Batch batch) {
        ClientCall<QueryOuterClass.Batch, QueryOuterClass.Response> call = this.channel.newCall(StargateBridgeGrpc.getExecuteBatchMethod(), this.callOptions);
        UnaryStreamObserver observer = new UnaryStreamObserver();
        ClientCalls.asyncUnaryCall(call, batch, observer);
        return observer.asFuture();
    }

    @Override
    public CompletionStage<Optional<Schema.CqlKeyspaceDescribe>> getKeyspaceAsync(String keyspaceName, boolean checkIfAuthorized) {
        if (checkIfAuthorized) {
            return this.authorizeSchemaReadAsync(SchemaReads.keyspace(keyspaceName, this.sourceApi)).thenCompose(authorized -> {
                if (!authorized.booleanValue()) {
                    throw new UnauthorizedKeyspaceException(keyspaceName);
                }
                return this.getAuthorizedKeyspace(keyspaceName).thenApply(Optional::ofNullable);
            });
        }
        return this.getAuthorizedKeyspace(keyspaceName).thenApply(Optional::ofNullable);
    }

    private CompletionStage<Schema.CqlKeyspaceDescribe> getAuthorizedKeyspace(String keyspaceName) {
        CompletableFuture<Schema.CqlKeyspaceDescribe> result = new CompletableFuture<Schema.CqlKeyspaceDescribe>();
        Schema.CqlKeyspaceDescribe cached = this.keyspaceCache.getIfPresent(keyspaceName);
        Optional<Integer> cachedHash = Optional.ofNullable(cached).filter(Schema.CqlKeyspaceDescribe::hasHash).map(d -> d.getHash().getValue());
        this.fetchKeyspaceFromBridge(keyspaceName, cachedHash).whenComplete((fetched, error) -> {
            if (error instanceof StatusRuntimeException && ((StatusRuntimeException)error).getStatus().getCode() == Status.Code.NOT_FOUND) {
                if (cached != null) {
                    this.keyspaceCache.invalidate(keyspaceName);
                }
                result.complete(null);
            } else if (error != null) {
                result.completeExceptionally((Throwable)error);
            } else if (!fetched.hasCqlKeyspace()) {
                result.complete(cached);
            } else {
                this.keyspaceCache.put(keyspaceName, (Schema.CqlKeyspaceDescribe)fetched);
                result.complete((Schema.CqlKeyspaceDescribe)fetched);
            }
        });
        return result;
    }

    private CompletionStage<Schema.CqlKeyspaceDescribe> fetchKeyspaceFromBridge(String keyspaceName, Optional<Integer> hash) {
        Schema.DescribeKeyspaceQuery.Builder query = Schema.DescribeKeyspaceQuery.newBuilder().setKeyspaceName(keyspaceName);
        hash.ifPresent(h2 -> query.setHash(Int32Value.of(h2)));
        ClientCall<Schema.DescribeKeyspaceQuery, Schema.CqlKeyspaceDescribe> call = this.channel.newCall(StargateBridgeGrpc.getDescribeKeyspaceMethod(), this.callOptions);
        UnaryStreamObserver observer = new UnaryStreamObserver();
        ClientCalls.asyncUnaryCall(call, query.build(), observer);
        return observer.asFuture();
    }

    @Override
    public CompletionStage<List<Schema.CqlKeyspaceDescribe>> getAllKeyspacesAsync() {
        CompletionStage<List<String>> allNamesFuture = this.getKeyspaceNames(new ArrayList<String>(), null);
        CompletionStage authorizedNamesFuture = allNamesFuture.thenCompose(names -> {
            List<Schema.SchemaRead> reads = names.stream().map(n -> SchemaReads.keyspace(n, this.sourceApi)).collect(Collectors.toList());
            return this.authorizeSchemaReadsAsync(reads).thenApply(authorizations -> this.removeUnauthorized((List)names, (List<Boolean>)authorizations));
        });
        return authorizedNamesFuture.thenCompose(this::getAuthorizedKeyspaces);
    }

    private <T> List<T> removeUnauthorized(List<T> elements, List<Boolean> authorizations) {
        assert (elements.size() == authorizations.size());
        ArrayList<T> filtered = new ArrayList<T>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            if (!authorizations.get(i).booleanValue()) continue;
            filtered.add(elements.get(i));
        }
        return filtered;
    }

    private CompletionStage<List<Schema.CqlKeyspaceDescribe>> getAuthorizedKeyspaces(List<String> keyspaceNames) {
        List keyspaceFutures = keyspaceNames.stream().map(this::getAuthorizedKeyspace).collect(Collectors.toList());
        return Futures.sequence(keyspaceFutures).thenApply(keyspaces -> keyspaces.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public String decorateKeyspaceName(String keyspaceName) {
        return this.addTenantPrefix(keyspaceName);
    }

    @Override
    public CompletionStage<Optional<Schema.CqlTable>> getTableAsync(String keyspaceName, String tableName, boolean checkIfAuthorized) {
        if (checkIfAuthorized) {
            return this.authorizeSchemaReadAsync(SchemaReads.table(keyspaceName, tableName, this.sourceApi)).thenCompose(authorized -> {
                if (!authorized.booleanValue()) {
                    throw new UnauthorizedTableException(keyspaceName, tableName);
                }
                return this.getAuthorizedTable(keyspaceName, tableName);
            });
        }
        return this.getAuthorizedTable(keyspaceName, tableName);
    }

    private CompletionStage<Optional<Schema.CqlTable>> getAuthorizedTable(String keyspaceName, String tableName) {
        return this.getAuthorizedKeyspace(keyspaceName).thenApply(ks -> ks == null ? Optional.empty() : ks.getTablesList().stream().filter(t -> t.getName().equals(tableName)).findFirst());
    }

    @Override
    public CompletionStage<List<Schema.CqlTable>> getTablesAsync(String keyspaceName) {
        return this.getAuthorizedKeyspace(keyspaceName).thenCompose(ks -> {
            if (ks == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            List<Schema.CqlTable> tables = ks.getTablesList();
            List<Schema.SchemaRead> reads = tables.stream().map(t -> SchemaReads.table(keyspaceName, t.getName(), this.sourceApi)).collect(Collectors.toList());
            return this.authorizeSchemaReadsAsync(reads).thenApply(authorizations -> this.removeUnauthorized((List)tables, (List<Boolean>)authorizations));
        });
    }

    @Override
    public CompletionStage<List<Boolean>> authorizeSchemaReadsAsync(List<Schema.SchemaRead> schemaReads) {
        ClientCall<Schema.AuthorizeSchemaReadsRequest, Schema.AuthorizeSchemaReadsResponse> call = this.channel.newCall(StargateBridgeGrpc.getAuthorizeSchemaReadsMethod(), this.callOptions);
        UnaryStreamObserver observer = new UnaryStreamObserver();
        ClientCalls.asyncUnaryCall(call, Schema.AuthorizeSchemaReadsRequest.newBuilder().addAllSchemaReads(schemaReads).build(), observer);
        return observer.asFuture().thenApply(Schema.AuthorizeSchemaReadsResponse::getAuthorizedList);
    }

    private CompletionStage<List<String>> getKeyspaceNames(List<String> accumulator, BytesValue pagingState) {
        QueryOuterClass.Query query = pagingState == null ? SELECT_KEYSPACE_NAMES : QueryOuterClass.Query.newBuilder(SELECT_KEYSPACE_NAMES).setParameters(QueryOuterClass.QueryParameters.newBuilder().setPagingState(pagingState).build()).build();
        return this.executeQueryAsync(query).thenCompose(response -> {
            QueryOuterClass.ResultSet resultSet = response.getResultSet();
            for (QueryOuterClass.Row row : resultSet.getRowsList()) {
                accumulator.add(row.getValues(0).getString());
            }
            return resultSet.hasPagingState() ? this.getKeyspaceNames(accumulator, resultSet.getPagingState()) : CompletableFuture.completedFuture(accumulator);
        });
    }

    private Channel addMetadata(Channel channel, String tenantId) {
        Metadata metadata = new Metadata();
        metadata.put(HOST_KEY, tenantId);
        return ClientInterceptors.intercept(channel, MetadataUtils.newAttachHeadersInterceptor(metadata));
    }

    private String encodeKeyspacePrefix(String tenantId) {
        return Hex.encodeHexString(tenantId.getBytes(StandardCharsets.UTF_8)) + "_";
    }

    private String addTenantPrefix(String keyspaceName) {
        return this.tenantPrefix + keyspaceName;
    }
}

