/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql.builder;

import io.stargate.sgv2.common.cql.builder.ImmutableTarget;
import io.stargate.sgv2.common.cql.builder.ImmutableValueModifier;
import io.stargate.sgv2.common.cql.builder.Term;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public interface ValueModifier {
    public Target target();

    public Operation operation();

    public Term value();

    public static ValueModifier set(String columnName, Object value) {
        return ValueModifier.set(columnName, Term.of(value));
    }

    public static ValueModifier set(String columnName, Term value) {
        return ValueModifier.of(Target.column(columnName), Operation.SET, value);
    }

    public static ValueModifier of(Target target, Operation operation, Term value) {
        return ImmutableValueModifier.builder().target(target).operation(operation).value(value).build();
    }

    @Value.Immutable
    @Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
    public static interface Target {
        public String columnName();

        @Nullable
        public String fieldName();

        @Nullable
        public Term mapKey();

        public static Target column(String columnName) {
            return ImmutableTarget.builder().columnName(columnName).build();
        }

        public static Target field(String columnName, String fieldName) {
            return ImmutableTarget.builder().columnName(columnName).fieldName(fieldName).build();
        }

        public static Target mapValue(String columnName, Term mapKey) {
            return ImmutableTarget.builder().columnName(columnName).mapKey(mapKey).build();
        }
    }

    public static enum Operation {
        SET,
        INCREMENT,
        APPEND,
        PREPEND,
        REMOVE;

    }
}

