/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.common.cql.builder.Term;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BuiltCondition", generator="Immutables")
@Immutable
final class ImmutableBuiltCondition
implements BuiltCondition {
    private final BuiltCondition.LHS lhs;
    private final Predicate predicate;
    private final Term value;

    private ImmutableBuiltCondition(BuiltCondition.LHS lhs, Predicate predicate, Term value) {
        this.lhs = lhs;
        this.predicate = predicate;
        this.value = value;
    }

    @Override
    public BuiltCondition.LHS lhs() {
        return this.lhs;
    }

    @Override
    public Predicate predicate() {
        return this.predicate;
    }

    @Override
    public Term value() {
        return this.value;
    }

    public final ImmutableBuiltCondition withLhs(BuiltCondition.LHS value) {
        if (this.lhs == value) {
            return this;
        }
        BuiltCondition.LHS newValue = Objects.requireNonNull(value, "lhs");
        return new ImmutableBuiltCondition(newValue, this.predicate, this.value);
    }

    public final ImmutableBuiltCondition withPredicate(Predicate value) {
        if (this.predicate == value) {
            return this;
        }
        Predicate newValue = Objects.requireNonNull(value, "predicate");
        if (this.predicate.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableBuiltCondition(this.lhs, newValue, this.value);
    }

    public final ImmutableBuiltCondition withValue(Term value) {
        if (this.value == value) {
            return this;
        }
        Term newValue = Objects.requireNonNull(value, "value");
        return new ImmutableBuiltCondition(this.lhs, this.predicate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBuiltCondition && this.equalTo((ImmutableBuiltCondition)another);
    }

    private boolean equalTo(ImmutableBuiltCondition another) {
        return this.lhs.equals(another.lhs) && this.predicate.equals((Object)another.predicate) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.lhs.hashCode();
        h2 += (h2 << 5) + this.predicate.hashCode();
        h2 += (h2 << 5) + this.value.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("BuiltCondition").omitNullValues().add("lhs", this.lhs).add("predicate", (Object)this.predicate).add("value", this.value).toString();
    }

    public static ImmutableBuiltCondition copyOf(BuiltCondition instance) {
        if (instance instanceof ImmutableBuiltCondition) {
            return (ImmutableBuiltCondition)instance;
        }
        return ImmutableBuiltCondition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BuiltCondition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LHS = 1L;
        private static final long INIT_BIT_PREDICATE = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private BuiltCondition.LHS lhs;
        @Nullable
        private Predicate predicate;
        @Nullable
        private Term value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BuiltCondition instance) {
            Objects.requireNonNull(instance, "instance");
            this.lhs(instance.lhs());
            this.predicate(instance.predicate());
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lhs(BuiltCondition.LHS lhs) {
            this.lhs = Objects.requireNonNull(lhs, "lhs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predicate(Predicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Term value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBuiltCondition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBuiltCondition(this.lhs, this.predicate, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lhs");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("predicate");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build BuiltCondition, some of required attributes are not set " + attributes;
        }
    }
}

