/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.proto;

import com.salesforce.reactorgrpc.stub.ClientCalls;
import com.salesforce.reactorgrpc.stub.ServerCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.stargate.proto.QueryOuterClass;
import io.stargate.proto.Schema;
import io.stargate.proto.StargateBridgeGrpc;
import reactor.core.publisher.Mono;

public final class ReactorStargateBridgeGrpc {
    public static final int METHODID_EXECUTE_QUERY = 0;
    public static final int METHODID_EXECUTE_BATCH = 1;
    public static final int METHODID_DESCRIBE_KEYSPACE = 2;
    public static final int METHODID_AUTHORIZE_SCHEMA_READS = 3;

    private ReactorStargateBridgeGrpc() {
    }

    public static ReactorStargateBridgeStub newReactorStub(Channel channel) {
        return new ReactorStargateBridgeStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final StargateBridgeImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(StargateBridgeImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    ServerCalls.oneToOne((QueryOuterClass.Query)request, responseObserver, this.serviceImpl::executeQuery);
                    break;
                }
                case 1: {
                    ServerCalls.oneToOne((QueryOuterClass.Batch)request, responseObserver, this.serviceImpl::executeBatch);
                    break;
                }
                case 2: {
                    ServerCalls.oneToOne((Schema.DescribeKeyspaceQuery)request, responseObserver, this.serviceImpl::describeKeyspace);
                    break;
                }
                case 3: {
                    ServerCalls.oneToOne((Schema.AuthorizeSchemaReadsRequest)request, responseObserver, this.serviceImpl::authorizeSchemaReads);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class StargateBridgeImplBase
    implements BindableService {
        public Mono<QueryOuterClass.Response> executeQuery(Mono<QueryOuterClass.Query> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<QueryOuterClass.Response> executeBatch(Mono<QueryOuterClass.Batch> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Schema.CqlKeyspaceDescribe> describeKeyspace(Mono<Schema.DescribeKeyspaceQuery> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Mono<Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(Mono<Schema.AuthorizeSchemaReadsRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(StargateBridgeGrpc.getServiceDescriptor()).addMethod(StargateBridgeGrpc.getExecuteQueryMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(StargateBridgeGrpc.getExecuteBatchMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(StargateBridgeGrpc.getDescribeKeyspaceMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(StargateBridgeGrpc.getAuthorizeSchemaReadsMethod(), io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }

        protected CallOptions getCallOptions(int methodId) {
            return null;
        }
    }

    public static final class ReactorStargateBridgeStub
    extends AbstractStub<ReactorStargateBridgeStub> {
        private StargateBridgeGrpc.StargateBridgeStub delegateStub;

        private ReactorStargateBridgeStub(Channel channel) {
            super(channel);
            this.delegateStub = StargateBridgeGrpc.newStub(channel);
        }

        private ReactorStargateBridgeStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = StargateBridgeGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected ReactorStargateBridgeStub build(Channel channel, CallOptions callOptions) {
            return new ReactorStargateBridgeStub(channel, callOptions);
        }

        public Mono<QueryOuterClass.Response> executeQuery(Mono<QueryOuterClass.Query> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::executeQuery, this.getCallOptions());
        }

        public Mono<QueryOuterClass.Response> executeBatch(Mono<QueryOuterClass.Batch> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::executeBatch, this.getCallOptions());
        }

        public Mono<Schema.CqlKeyspaceDescribe> describeKeyspace(Mono<Schema.DescribeKeyspaceQuery> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::describeKeyspace, this.getCallOptions());
        }

        public Mono<Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(Mono<Schema.AuthorizeSchemaReadsRequest> reactorRequest) {
            return ClientCalls.oneToOne(reactorRequest, this.delegateStub::authorizeSchemaReads, this.getCallOptions());
        }

        public Mono<QueryOuterClass.Response> executeQuery(QueryOuterClass.Query reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::executeQuery, this.getCallOptions());
        }

        public Mono<QueryOuterClass.Response> executeBatch(QueryOuterClass.Batch reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::executeBatch, this.getCallOptions());
        }

        public Mono<Schema.CqlKeyspaceDescribe> describeKeyspace(Schema.DescribeKeyspaceQuery reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::describeKeyspace, this.getCallOptions());
        }

        public Mono<Schema.AuthorizeSchemaReadsResponse> authorizeSchemaReads(Schema.AuthorizeSchemaReadsRequest reactorRequest) {
            return ClientCalls.oneToOne(Mono.just(reactorRequest), this.delegateStub::authorizeSchemaReads, this.getCallOptions());
        }
    }
}

