/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.tags;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class HeadersTagProvider
implements JerseyTagsProvider {
    private final Config config;

    public HeadersTagProvider() {
        this(Config.fromSystemProps());
    }

    public HeadersTagProvider(Config config) {
        this.config = config;
    }

    @Override
    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        return this.getRequestTags(event.getContainerRequest().getHeaders());
    }

    @Override
    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        return this.getRequestTags(event.getContainerRequest().getHeaders());
    }

    private Tags getRequestTags(Map<String, List<String>> headers) {
        Collection whitelist = this.config.whitelistedHeaderNames;
        if (null == whitelist || whitelist.isEmpty()) {
            return Tags.empty();
        }
        Tag[] collect = (Tag[])whitelist.stream().map(header -> headers.entrySet().stream().filter(e -> Objects.equals(header, ((String)e.getKey()).toLowerCase())).findAny().map(e -> Tag.of(header, String.join((CharSequence)",", (Iterable)e.getValue()))).orElseGet(() -> Tag.of(header, "unknown"))).toArray(Tag[]::new);
        return Tags.of(collect);
    }

    public static class Config {
        private final Collection<String> whitelistedHeaderNames;

        public Config(Collection<String> whitelistedHeaderNames) {
            this.whitelistedHeaderNames = null == whitelistedHeaderNames ? Collections.emptyList() : whitelistedHeaderNames;
        }

        public static Config fromSystemProps() {
            String property = System.getProperty("stargate.metrics.http_server_requests_header_tags");
            return Config.fromPropertyString(property);
        }

        public static Config fromPropertyString(String value) {
            try {
                if (null != value && value.length() > 0) {
                    String[] headers = value.split(",");
                    List<String> lowercaseHeaders = Arrays.stream(headers).map(String::toLowerCase).collect(Collectors.toList());
                    return new Config(lowercaseHeaders);
                }
                return new Config(Collections.emptyList());
            }
            catch (Exception e) {
                return new Config(Collections.emptyList());
            }
        }
    }
}

