/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import java.nio.ByteBuffer;
import java.util.Base64;

public class BytesValues {
    public static BytesValue of(byte[] bytes) {
        return BytesValue.of(ByteString.copyFrom(bytes));
    }

    public static BytesValue of(ByteBuffer byteBuffer) {
        return BytesValue.of(ByteString.copyFrom(byteBuffer));
    }

    public static BytesValue ofBase64(String base64) {
        return BytesValues.of(Base64.getDecoder().decode(base64));
    }

    public static byte[] toBytes(BytesValue value) {
        return value.getValue().toByteArray();
    }

    public static ByteBuffer toByteBuffer(BytesValue value) {
        return value.getValue().asReadOnlyByteBuffer();
    }

    public static String toBase64(BytesValue value) {
        return Base64.getEncoder().encodeToString(BytesValues.toBytes(value));
    }

    private BytesValues() {
    }
}

