/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.core.activator;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.stargate.core.activator.ServiceStartException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(BaseActivator.class);
    private final ServicePointer<HealthCheckRegistry> healthCheckRegistry = ServicePointer.create(HealthCheckRegistry.class);
    private final String activatorName;
    private final AtomicBoolean available = new AtomicBoolean();
    private final HealthCheck healthCheck;
    private List<ServicePointer<?>> dependencies;
    protected BundleContext context;
    public boolean started;
    public Tracker tracker;
    private final List<ServiceRegistration<?>> targetServiceRegistrations = new ArrayList();

    public BaseActivator(String activatorName) {
        this(activatorName, false);
    }

    public BaseActivator(String activatorName, boolean registerHealthCheck) {
        this.activatorName = activatorName;
        this.healthCheck = registerHealthCheck ? new HealthCheck(){

            @Override
            protected HealthCheck.Result check() {
                return BaseActivator.this.available.get() ? HealthCheck.Result.healthy("Available") : HealthCheck.Result.unhealthy("Not Available");
            }
        } : null;
    }

    public synchronized void start(BundleContext context) throws InvalidSyntaxException {
        logger.info("Starting {} ...", (Object)this.activatorName);
        this.context = context;
        String filter = this.constructDependenciesFilter();
        if (this.dependencies.isEmpty() && this.lazyDependencies().isEmpty()) {
            this.startServiceInternal();
        } else {
            this.tracker = new Tracker(context, context.createFilter(filter));
            this.tracker.open();
        }
    }

    String constructDependenciesFilter() {
        List<ServicePointer<?>> dep = this.dependencies();
        if (this.healthCheck != null) {
            dep = new ArrayList(dep);
            dep.add(this.healthCheckRegistry);
        }
        this.dependencies = dep;
        StringBuilder builder = new StringBuilder("(|");
        ArrayList<Service> allDependencies = new ArrayList<Service>();
        allDependencies.addAll(this.dependencies);
        allDependencies.addAll(this.lazyDependencies());
        for (Service servicePointer : allDependencies) {
            if (servicePointer.identifier.isPresent()) {
                builder.append(String.format("(%s)", servicePointer.identifier.get()));
                continue;
            }
            builder.append(String.format("(objectClass=%s)", servicePointer.expectedClass.getName()));
        }
        builder.append(")");
        return builder.toString();
    }

    public synchronized void stop(BundleContext context) throws Exception {
        this.available.set(false);
        if (this.started) {
            logger.info("Stopping {}", (Object)this.activatorName);
            this.stopService();
            this.deregisterService();
        }
        this.tracker.close();
    }

    private void deregisterService() {
        for (ServiceRegistration<?> serviceRegistration : this.targetServiceRegistrations) {
            if (serviceRegistration == null) continue;
            ServiceReference reference = serviceRegistration.getReference();
            logger.info("Unget service {} from {}", (Object)reference.getBundle(), (Object)this.activatorName);
            this.context.ungetService(reference);
        }
    }

    private synchronized void startServiceInternal() {
        if (this.started) {
            logger.info("The {} is already started. Ignoring the start request.", (Object)this.activatorName);
            return;
        }
        this.started = true;
        if (this.healthCheck != null) {
            String healthCheckName = this.activatorName.toLowerCase();
            this.healthCheckRegistry.get().register(healthCheckName, this.healthCheck);
        }
        try {
            List<ServiceAndProperties> services = this.createServices();
            for (ServiceAndProperties service : services) {
                if (service == null) continue;
                logger.info("Registering {} as {}", (Object)this.activatorName, (Object)service.targetServiceClass.getName());
                this.targetServiceRegistrations.add(this.context.registerService(service.targetServiceClass.getName(), service.service, (Dictionary)service.properties));
            }
            this.available.set(true);
            logger.info("Started {}", (Object)this.activatorName);
        }
        catch (Exception e) {
            throw new ServiceStartException("Unable to start " + this.activatorName, e);
        }
    }

    protected List<ServiceAndProperties> createServices() {
        return Collections.singletonList(this.createService());
    }

    protected ServiceAndProperties createService() {
        return null;
    }

    protected void stopService() {
    }

    protected File getBaseDir() throws IOException {
        String baseDir = System.getProperty("stargate.basedir");
        if (baseDir == null || baseDir.isEmpty()) {
            return Files.createTempDirectory("stargate-" + this.activatorName, new FileAttribute[0]).toFile();
        }
        return Files.createDirectories(Paths.get(baseDir, "stargate-" + this.activatorName), new FileAttribute[0]).toFile();
    }

    protected abstract List<ServicePointer<?>> dependencies();

    protected List<LazyServicePointer<?>> lazyDependencies() {
        return Collections.emptyList();
    }

    public static class LazyServicePointer<T>
    extends Service<T> {
        private final AtomicReference<T> service = new AtomicReference();

        private LazyServicePointer(Class<T> expectedClass, String identifier) {
            this.expectedClass = expectedClass;
            this.identifier = Optional.ofNullable(identifier);
        }

        public static <T> LazyServicePointer<T> create(Class<T> className, String identifierKey, String identifierValue) {
            return new LazyServicePointer<T>(className, LazyServicePointer.createIdentifier(identifierKey, identifierValue));
        }

        public static <T> LazyServicePointer<T> create(Class<T> className) {
            return new LazyServicePointer<T>(className, null);
        }

        public AtomicReference<T> get() {
            return this.service;
        }

        private void set(Object service) {
            this.service.set(service);
        }
    }

    public static class ServicePointer<T>
    extends Service<T> {
        private T service;

        private ServicePointer(Class<T> expectedClass, String identifier) {
            this.expectedClass = expectedClass;
            this.identifier = Optional.ofNullable(identifier);
        }

        public static <T> ServicePointer<T> create(Class<T> className, String identifierKey, String identifierValue) {
            return new ServicePointer<T>(className, ServicePointer.createIdentifier(identifierKey, identifierValue));
        }

        public static <T> ServicePointer<T> create(Class<T> className) {
            return new ServicePointer<T>(className, null);
        }

        public T get() {
            return this.service;
        }

        private void set(Object service) {
            this.service = service;
        }
    }

    private static abstract class Service<T> {
        protected Class<T> expectedClass;
        protected Optional<String> identifier;

        private Service() {
        }

        protected static String createIdentifier(String identifierKey, String identifierValue) {
            return String.format("%s=%s", identifierKey, identifierValue);
        }
    }

    public static class ServiceAndProperties {
        private final Object service;
        private final Class<?> targetServiceClass;
        private final Hashtable<String, String> properties;

        public <T> ServiceAndProperties(T service, Class<? super T> targetServiceClass, Hashtable<String, String> properties) {
            this.service = service;
            this.targetServiceClass = targetServiceClass;
            this.properties = properties;
        }

        public <T> ServiceAndProperties(T service, Class<? super T> targetServiceClass) {
            this(service, targetServiceClass, new Hashtable<String, String>());
        }
    }

    public class Tracker
    extends ServiceTracker<Object, Object> {
        public Tracker(BundleContext context, Filter filter) {
            super(context, filter, null);
        }

        public Object addingService(ServiceReference<Object> ref) {
            Object service = super.addingService(ref);
            this.startIfAllRegistered(ref, service);
            return service;
        }

        public void startIfAllRegistered(ServiceReference<Object> ref, Object service) {
            if (service == null) {
                return;
            }
            for (ServicePointer servicePointer : BaseActivator.this.dependencies) {
                if (!servicePointer.expectedClass.isAssignableFrom(service.getClass())) continue;
                logger.debug("{} using service: {}", (Object)BaseActivator.this.activatorName, (Object)ref.getBundle());
                servicePointer.set(service);
            }
            for (LazyServicePointer lazyServicePointer : BaseActivator.this.lazyDependencies()) {
                if (!lazyServicePointer.expectedClass.isAssignableFrom(service.getClass())) continue;
                logger.debug("{} using service with lazy init: {}", (Object)BaseActivator.this.activatorName, (Object)ref.getBundle());
                lazyServicePointer.set(service);
            }
            if (BaseActivator.this.dependencies.stream().map(v -> ((ServicePointer)v).service).allMatch(Objects::nonNull)) {
                BaseActivator.this.startServiceInternal();
            }
        }
    }
}

