/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation.selfvalidating;

import com.fasterxml.classmate.AnnotationConfiguration;
import com.fasterxml.classmate.AnnotationInclusion;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import io.dropwizard.validation.selfvalidating.SelfValidating;
import io.dropwizard.validation.selfvalidating.SelfValidation;
import io.dropwizard.validation.selfvalidating.ValidationCaller;
import io.dropwizard.validation.selfvalidating.ViolationCollector;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfValidatingValidator
implements ConstraintValidator<SelfValidating, Object> {
    private static final Logger log = LoggerFactory.getLogger(SelfValidatingValidator.class);
    private final ConcurrentMap<Class<?>, List<ValidationCaller>> methodMap = new ConcurrentHashMap();
    private final AnnotationConfiguration annotationConfiguration = new AnnotationConfiguration.StdConfiguration(AnnotationInclusion.INCLUDE_AND_INHERIT_IF_INHERITED);
    private final TypeResolver typeResolver = new TypeResolver();
    private final MemberResolver memberResolver = new MemberResolver(this.typeResolver);
    private boolean escapeExpressions = true;

    @Override
    public void initialize(SelfValidating constraintAnnotation) {
        this.escapeExpressions = constraintAnnotation.escapeExpressions();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        ViolationCollector collector = new ViolationCollector(context, this.escapeExpressions);
        context.disableDefaultConstraintViolation();
        for (ValidationCaller caller : this.methodMap.computeIfAbsent(value.getClass(), this::findMethods)) {
            caller.setValidationObject(value);
            caller.call(collector);
        }
        return !collector.hasViolationOccurred();
    }

    private <T> List<ValidationCaller> findMethods(Class<T> annotated) {
        ResolvedTypeWithMembers annotatedType = this.memberResolver.resolve(this.typeResolver.resolve(annotated, new Type[0]), this.annotationConfiguration, null);
        List<ValidationCaller> callers = Arrays.stream(annotatedType.getMemberMethods()).filter(this::isValidationMethod).filter(this::isMethodCorrect).map(m3 -> new ProxyValidationCaller(annotated, (ResolvedMethod)m3)).collect(Collectors.toList());
        if (callers.isEmpty()) {
            log.warn("The class {} is annotated with @SelfValidating but contains no valid methods that are annotated with @SelfValidation", (Object)annotated);
        }
        return callers;
    }

    private boolean isValidationMethod(ResolvedMethod m3) {
        return m3.get(SelfValidation.class) != null;
    }

    boolean isMethodCorrect(ResolvedMethod m3) {
        if (m3.getReturnType() != null) {
            log.error("The method {} is annotated with @SelfValidation but does not return void. It is ignored", m3.getRawMember());
            return false;
        }
        if (m3.getArgumentCount() != 1 || !m3.getArgumentType(0).getErasedType().equals(ViolationCollector.class)) {
            log.error("The method {} is annotated with @SelfValidation but does not have a single parameter of type {}", m3.getRawMember(), (Object)ViolationCollector.class);
            return false;
        }
        if (!m3.isPublic()) {
            log.error("The method {} is annotated with @SelfValidation but is not public", m3.getRawMember());
            return false;
        }
        return true;
    }

    static final class ProxyValidationCaller<T>
    extends ValidationCaller<T> {
        private final Class<T> cls;
        private final ResolvedMethod resolvedMethod;

        ProxyValidationCaller(Class<T> cls, ResolvedMethod resolvedMethod) {
            this.cls = cls;
            this.resolvedMethod = resolvedMethod;
        }

        @Override
        public void call(ViolationCollector vc) {
            Method method = (Method)this.resolvedMethod.getRawMember();
            T obj = this.cls.cast(this.getValidationObject());
            try {
                method.invoke(obj, vc);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Couldn't call " + this.resolvedMethod + " on " + this.getValidationObject(), e);
            }
        }
    }
}

