/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.EnumValueDefinition;
import graphql.language.IgnoredChars;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class EnumTypeDefinition
extends AbstractDescribedNode<EnumTypeDefinition>
implements TypeDefinition<EnumTypeDefinition>,
DirectivesContainer<EnumTypeDefinition>,
NamedNode<EnumTypeDefinition> {
    private final String name;
    private final ImmutableList<EnumValueDefinition> enumValueDefinitions;
    private final ImmutableList<Directive> directives;
    public static final String CHILD_ENUM_VALUE_DEFINITIONS = "enumValueDefinitions";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    protected EnumTypeDefinition(String name, List<EnumValueDefinition> enumValueDefinitions, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData, description);
        this.name = name;
        this.directives = ImmutableKit.nonNullCopyOf(directives);
        this.enumValueDefinitions = ImmutableKit.nonNullCopyOf(enumValueDefinitions);
    }

    public EnumTypeDefinition(String name) {
        this(name, ImmutableKit.emptyList(), ImmutableKit.emptyList(), null, null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    public List<EnumValueDefinition> getEnumValueDefinitions() {
        return this.enumValueDefinitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.enumValueDefinitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_ENUM_VALUE_DEFINITIONS, this.enumValueDefinitions).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public EnumTypeDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.enumValueDefinitions(newChildren.getChildren(CHILD_ENUM_VALUE_DEFINITIONS)).directives(newChildren.getChildren(CHILD_DIRECTIVES)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypeDefinition that = (EnumTypeDefinition)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public EnumTypeDefinition deepCopy() {
        return new EnumTypeDefinition(this.name, this.deepCopy(this.enumValueDefinitions), this.deepCopy(this.directives), this.description, this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "EnumTypeDefinition{name='" + this.name + '\'' + ", enumValueDefinitions=" + this.enumValueDefinitions + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitEnumTypeDefinition(this, context);
    }

    public static Builder newEnumTypeDefinition() {
        return new Builder();
    }

    public EnumTypeDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Description description;
        private ImmutableList<EnumValueDefinition> enumValueDefinitions = ImmutableKit.emptyList();
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(EnumTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.enumValueDefinitions = ImmutableList.copyOf(existing.getEnumValueDefinitions());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder enumValueDefinitions(List<EnumValueDefinition> enumValueDefinitions) {
            this.enumValueDefinitions = ImmutableList.copyOf(enumValueDefinitions);
            return this;
        }

        public Builder enumValueDefinition(EnumValueDefinition enumValueDefinition) {
            this.enumValueDefinitions = ImmutableKit.addToList(this.enumValueDefinitions, enumValueDefinition, new EnumValueDefinition[0]);
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public EnumTypeDefinition build() {
            return new EnumTypeDefinition(this.name, this.enumValueDefinitions, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

