/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@PublicApi
public interface DirectivesContainer<T extends DirectivesContainer>
extends Node<T> {
    public List<Directive> getDirectives();

    default public Map<String, List<Directive>> getDirectivesByName() {
        return ImmutableMap.copyOf(NodeUtil.allDirectivesByName(this.getDirectives()));
    }

    default public List<Directive> getDirectives(String directiveName) {
        return this.getDirectivesByName().getOrDefault(directiveName, Collections.emptyList());
    }

    default public boolean hasDirective(String directiveName) {
        return !this.getDirectives(directiveName).isEmpty();
    }
}

