/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.preparsed.persisted;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.PublicSpi;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.execution.preparsed.persisted.PersistedQueryCache;
import graphql.execution.preparsed.persisted.PersistedQueryError;
import graphql.execution.preparsed.persisted.PersistedQueryIdInvalid;
import graphql.execution.preparsed.persisted.PersistedQueryNotFound;
import java.util.Optional;
import java.util.function.Function;

@PublicSpi
public abstract class PersistedQuerySupport
implements PreparsedDocumentProvider {
    public static final String PERSISTED_QUERY_MARKER = "PersistedQueryMarker";
    private final PersistedQueryCache persistedQueryCache;

    public PersistedQuerySupport(PersistedQueryCache persistedQueryCache) {
        this.persistedQueryCache = Assert.assertNotNull(persistedQueryCache);
    }

    @Override
    public PreparsedDocumentEntry getDocument(ExecutionInput executionInput, Function<ExecutionInput, PreparsedDocumentEntry> parseAndValidateFunction) {
        Optional<Object> queryIdOption = this.getPersistedQueryId(executionInput);
        Assert.assertNotNull(queryIdOption, () -> String.format("The class %s MUST return a non null optional query id", this.getClass().getName()));
        try {
            if (queryIdOption.isPresent()) {
                Object persistedQueryId = queryIdOption.get();
                return this.persistedQueryCache.getPersistedQueryDocument(persistedQueryId, executionInput, queryText -> {
                    if (queryText == null || queryText.trim().length() == 0) {
                        throw new PersistedQueryNotFound(persistedQueryId);
                    }
                    if (this.persistedQueryIdIsInvalid(persistedQueryId, queryText)) {
                        throw new PersistedQueryIdInvalid(persistedQueryId);
                    }
                    ExecutionInput newEI = executionInput.transform(builder -> builder.query(queryText));
                    return (PreparsedDocumentEntry)parseAndValidateFunction.apply(newEI);
                });
            }
            return parseAndValidateFunction.apply(executionInput);
        }
        catch (PersistedQueryError e) {
            return this.mkMissingError(e);
        }
    }

    protected abstract Optional<Object> getPersistedQueryId(ExecutionInput var1);

    protected boolean persistedQueryIdIsInvalid(Object persistedQueryId, String queryText) {
        return false;
    }

    protected PreparsedDocumentEntry mkMissingError(PersistedQueryError persistedQueryError) {
        GraphQLError gqlError = GraphqlErrorBuilder.newError().errorType(persistedQueryError).message(persistedQueryError.getMessage(), new Object[0]).extensions(persistedQueryError.getExtensions()).build();
        return new PreparsedDocumentEntry(gqlError);
    }
}

