/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import io.grpc.CallOptions;

public final class ReactorCallOptions {
    public static final CallOptions.Key<Integer> CALL_OPTIONS_PREFETCH = CallOptions.Key.createWithDefault("reactivegrpc.internal.PREFETCH", 512);
    public static final CallOptions.Key<Integer> CALL_OPTIONS_LOW_TIDE = CallOptions.Key.createWithDefault("reactivegrpc.internal.LOW_TIDE", 341);

    private ReactorCallOptions() {
    }

    public static int getPrefetch(CallOptions options) {
        return options == null ? CALL_OPTIONS_PREFETCH.getDefault().intValue() : options.getOption(CALL_OPTIONS_PREFETCH).intValue();
    }

    public static int getLowTide(CallOptions options) {
        int lowTide;
        int prefetch = ReactorCallOptions.getPrefetch(options);
        int n = lowTide = options == null ? CALL_OPTIONS_LOW_TIDE.getDefault().intValue() : options.getOption(CALL_OPTIONS_LOW_TIDE).intValue();
        if (lowTide >= prefetch) {
            throw new IllegalArgumentException(CALL_OPTIONS_LOW_TIDE + " must be less than " + CALL_OPTIONS_PREFETCH);
        }
        return lowTide;
    }
}

