/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils.predicates;

import com.github.rvesse.airline.utils.predicates.AbstractLocaleSensitiveStringFinder;
import java.util.Locale;

public class SuffixMatcher
extends AbstractLocaleSensitiveStringFinder {
    private final String[] suffixes;
    private final boolean ignoreCase;

    public SuffixMatcher(boolean ignoreCase, Locale locale, String ... suffixes) {
        super(locale);
        this.ignoreCase = ignoreCase;
        this.suffixes = suffixes;
        if (ignoreCase) {
            for (int i = 0; i < this.suffixes.length; ++i) {
                this.suffixes[i] = this.suffixes[i].toLowerCase(locale);
            }
        }
    }

    @Override
    public boolean evaluate(String str) {
        for (String suffix : this.suffixes) {
            if (str.length() < suffix.length()) {
                return false;
            }
            String strSuffix = str.substring(str.length() - suffix.length());
            if (this.ignoreCase) {
                strSuffix = strSuffix.toLowerCase(this.locale);
            }
            if (this.collator.compare(strSuffix, suffix) != 0) continue;
            return true;
        }
        return false;
    }
}

